﻿#include "StateBase.h"
#include "../LoginManager.h"
#include "Log/CsdkLogMacros.h"
#include "Log/LogChatSdk.h"
#include "Tools/CsdkCommonTools.h"


void FStateBase::SwitchState(const ELoginStateId NextState) const
{
	if(!FCsdkCommonTools::IsAlive())
	{
		CSDK_LOG(LogChatSdk,Error,TEXT("Can't switch state for not alive"));
		Manager.SwitchState(ELoginStateId::PreLogin);
		return;
	}

	Manager.SwitchState(NextState);	
}

void FStateBase::CallLoginCallback(const int32 ErrorCode, const FString& Msg) const
{
	if(!FCsdkCommonTools::IsAlive())
		return;
	Manager.LoginCallback.ExecuteIfBound(ErrorCode, Msg);
	Manager.LoginCallback.Unbind();
}

