#pragma once
#include "ChatRoom/Manager/ChatRoomManager.h"
#include "Consensus/Manager/ConsensusManager.h"
#include "Init/Manager/InitManager.h"
#include "Login/Core/LoginManager.h"
#include "Message/Core/MessageManager.h"
#include "Relationship/Block/Mananger/BlockManager.h"
#include "Relationship/Friend/Mananger/FriendManager.h"
#include "Session/Core/SessionManager.h"
#include "Translate/Manager/TranslateManager.h"
#include "User/Manager/UserManager.h"


class UCsdkSubsystem;
class FCsdkManager
{
	friend  class FCsdkCommonTools;
	FCsdkManager() = default;
public:
	static FCsdkManager& GetInstance();

	void Register(UCsdkSubsystem* InSubsystem);
	void Unregister();
	
	UCsdkSubsystem* Subsystem = nullptr;
	
	FString GetDeviceId();
private:
	FInitManager InitManager;
	FLoginManager LoginManager;
	FFriendManager FriendManager;
	FBlockManager BlockManager;
	FUserManager UserManager;
	FMessageManager MessageManager;
	FSessionManager SessionManager;
	FChatRoomManager ChatRoomManager;
	FTranslateManager TranslateManager;
	FConsensusManager ConsensusManager;
	bool bIsAlive = false;
	FString DeviceId;

};


