#include "Message/CsdkMessageLibrary.h"
#include "Message/Core/CsdkTextMessage.h"
#include "Tools/CsdkCommonTools.h"


UCsdkTextMessage* UCsdkMessageLibrary::NewTextMsg(const FString& Content, const TMap<FString, FString>& Extra)
{
#if UE_SERVER	
	return {};
#endif
	UCsdkTextMessage* Message = NewObject<UCsdkTextMessage>();
	Message->MsgType = ECsdkMessageType::Text;
	Message->Content = Content;
	
	FillMsg(Message,Extra);
	return Message;
}

UCsdkVoiceMessage* UCsdkMessageLibrary::NewVoiceMsg( const FString& Url,const float Duration, const FString& Title, const TMap<FString, FString>& Extra)
{
#if UE_SERVER	
	return {};
#endif
	UCsdkVoiceMessage* Message = NewObject<UCsdkVoiceMessage>();
	Message->MsgType = ECsdkMessageType::Voice;
	Message->Url = Url;
	Message->Duration = Duration;
	Message->Title = Title;

	FillMsg(Message,Extra);
	return Message;
}

UCsdkCustomMessage* UCsdkMessageLibrary::NewCustomMsg(
	const FString& Content, const TMap<FString, FString>& Extra)
{
#if UE_SERVER	
	return {};
#endif
	UCsdkCustomMessage* Message = NewObject<UCsdkCustomMessage>();
	Message->MsgType = ECsdkMessageType::Custom;
	Message->Content = Content;
	
	FillMsg(Message,Extra);
	return Message;
}

void UCsdkMessageLibrary::FillMsg(UCsdkMessageBase* Message,const TMap<FString, FString>& Extra)
{
#if UE_SERVER	
	return;
#endif
	Message->ClientMsgId = FGuid::NewGuid().ToString();
	Message->Time = FDateTime::UtcNow();
	Message->Sender = FCsdkCommonTools::GetUserManager().GetCurrentUser();
	Message->bIsSelf = true;
	Message->Extra = Extra;
}
