#include "Message/CsdkPullMsg.h"
#include "Tools/CsdkCommonTools.h"


UCsdkPullMsg* UCsdkPullMsg::PullMsg(UObject* WorldContextObject, const FCsdkSessionId& SessionId, const FString& AnchorMsgId,
                                    const int32 DesiredPullCount, const ECsdkMsgPullDirection Direction)
{
#if UE_SERVER	
	return {};
#endif
	if(!FCsdkCommonTools::HasLogin())
		return nullptr;
	UCsdkPullMsg* Action = NewObject<UCsdkPullMsg>();

	Action->SessionId = SessionId;
	Action->AnchorMsgId = AnchorMsgId;
	Action->DesiredPullCount = DesiredPullCount;
	Action->Direction = Direction;
	
	Action->RegisterWithGameInstance(WorldContextObject);
	return Action;
}

void UCsdkPullMsg::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetMessageManager().PullMessage(SessionId,AnchorMsgId,DesiredPullCount,Direction,
   [this](const int32 ErrorCode, const FString& ErrorMsg, const TArray<UCsdkMessageBase*>& Messages)
   {
   		if(!IsValidLowLevel())
   			return;
   	
   		this->Completed.Broadcast(ErrorCode,ErrorMsg,SessionId, Messages);
		this->SetReadyToDestroy();
   		
   });
}
