// Fill out your copyright notice in the Description page of Project Settings.


#include "Relationship/Block/CsdkGetBlockList.h"
#include "Tools/CsdkCommonTools.h"


UCsdkGetBlockList* UCsdkGetBlockList::GetBlockList(UObject* WorldContextObject)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkGetBlockList* Action = NewObject<UCsdkGetBlockList>();
	Action->RegisterWithGameInstance(WorldContextObject);

	return Action;
}

void UCsdkGetBlockList::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetBlockManager().GetBlockList(
	[this](const int32 ErrorCode, const FString& ErrorMsg,const TArray<FCsdkBlock>& Blocks)
	{
		if(!this->IsValidLowLevel())
			return;
		
		this->Completed.Broadcast(ErrorCode,ErrorMsg,Blocks);
		this->SetReadyToDestroy();
	});
}


