#pragma once
#include "Message/Core/CsdkMessageBase.h"
#include "Relationship/Block/Data/CsdkBlock.h"
#include "User/Data/CsdkUserId.h"

class FBlockManager 
{
public:
	void Init();

	void Reset();
	void GetBlockList(const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg, const TArray<FCsdkBlock>&)>& Callback);
	void AddBlock(const FCsdkUserId& UserId,const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg)>& Callback);
	void RemoveBlock(const FCsdkUserId& UserId,const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg)>& Callback);
	bool IsUserIdBlocked(const FCsdkUserId& UserId) const;
	TArray<UCsdkMessageBase*> FilterMsgsSenderNotBlocked(const TArray<UCsdkMessageBase*>& InMsgs) const;
private:
	void GetBlockList_Internal(const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg, const TArray<FCsdkBlock>&)>& Callback);
private:
	TMap<FCsdkUserId,FCsdkBlock> BlockMap;
	bool bIsPull = false;
};




