// Fill out your copyright notice in the Description page of Project Settings.


#include "Relationship/Friend/CsdkGetFriendList.h"
#include "Tools/CsdkCommonTools.h"


UCsdkGetFriendList* UCsdkGetFriendList::GetFriendList(UObject* WorldContextObject)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkGetFriendList* Action = NewObject<UCsdkGetFriendList>();
	Action->RegisterWithGameInstance(WorldContextObject);
	FCsdkCommonTools::GetFriendManager().GetFriendList(
   [Action](const int32 ErrorCode, const FString& ErrorMsg, const TArray<FCsdkFriend>& FriendList)
   {
   		if(!Action->IsValidLowLevel())
   			return;
   	
   		Action->Completed.Broadcast(ErrorCode,ErrorMsg, FriendList);
   		Action->SetReadyToDestroy();
   });
	return Action;
}



