// Fill out your copyright notice in the Description page of Project Settings.


#include "Relationship/Friend/CsdkFriendListApplyOperate.h"
#include "Tools/CsdkCommonTools.h"


UCsdkFriendListApplyOperate* UCsdkFriendListApplyOperate::AgreeFriendListApply(UObject* WorldContextObject,
	const TArray<FString>& Tokens)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkFriendListApplyOperate* Action = NewObject<UCsdkFriendListApplyOperate>();
	Action->RegisterWithGameInstance(WorldContextObject);
	FCsdkCommonTools::GetFriendManager().AgreeFriendApply(Tokens,
   [Action](const int32 ErrorCode,const FString& ErrorMsg,const TArray<FCsdkOperateFriendApplyResult>& AgreeListResult )
   {
		if(!Action->IsValidLowLevel())
   			return;
   	
   		Action->Completed.Broadcast(ErrorCode,ErrorMsg, AgreeListResult);
   		Action->SetReadyToDestroy();
   });
	return Action;
}


UCsdkFriendListApplyOperate* UCsdkFriendListApplyOperate::RefuseFriendListApply(UObject* WorldContextObject,const TArray<FString>& Tokens)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkFriendListApplyOperate* Action = NewObject<UCsdkFriendListApplyOperate>();
	Action->RegisterWithGameInstance(WorldContextObject);
	FCsdkCommonTools::GetFriendManager().RefuseFriendApply(Tokens,
   [Action](const int32 ErrorCode, const FString& ErrorMsg,const TArray<FCsdkOperateFriendApplyResult>& AgreeListResult )
   {
   		if(!Action->IsValidLowLevel())
   			return;
   	
   		Action->Completed.Broadcast(ErrorCode,ErrorMsg, AgreeListResult);
	    Action->SetReadyToDestroy();
   });
	return Action;
}