// Fill out your copyright notice in the Description page of Project Settings.


#include "Relationship/Friend/CsdkOperateFriend.h"

#include "Relationship/Friend/CsdkOperateFriendList.h"
#include "Tools/CsdkCommonTools.h"

UCsdkOperateFriend* UCsdkOperateFriend::AddFriend(UObject* WorldContextObject, const FCsdkUserId& UserId)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkOperateFriend* Action = NewObject<UCsdkOperateFriend>();
	Action->RegisterWithGameInstance(WorldContextObject);
	FCsdkCommonTools::GetFriendManager().AddFriend(UserId,
		[Action](const int32 ErrorCode, const FString& ErrorMsg)
		{
			if(!Action->IsValidLowLevel())
				return;
			
			Action->Completed.Broadcast(ErrorCode,ErrorMsg);
			Action->SetReadyToDestroy();
		});
	return Action;
}

UCsdkOperateFriend* UCsdkOperateFriend::DeleteFriend(UObject* WorldContextObject, const FCsdkUserId& UserId)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkOperateFriend* Action = NewObject<UCsdkOperateFriend>();
	Action->RegisterWithGameInstance(WorldContextObject);
	FCsdkCommonTools::GetFriendManager().DeleteFriend(UserId,
		[Action](const int32 ErrorCode,const FString& ErrorMsg)
		{
			if(!Action->IsValidLowLevel())
				return;
			
			Action->Completed.Broadcast(ErrorCode,ErrorMsg);
			Action->SetReadyToDestroy();
		});
	return Action;
}

UCsdkOperateFriend* UCsdkOperateFriend::UpdateFriendInfo(UObject* WorldContextObject,
	const FCsdkUserId& UserId, const TMap<FString, FString>& UserInfoExtra)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkOperateFriend* Action = NewObject<UCsdkOperateFriend>();
	Action->RegisterWithGameInstance(WorldContextObject);
	FCsdkCommonTools::GetFriendManager().UpdateFriendInfo(UserId, UserInfoExtra,
		[Action](const int32 ErrorCode,const FString& ErrorMsg)
		{
			if(!Action->IsValidLowLevel())
				return;
			
			Action->Completed.Broadcast(ErrorCode,ErrorMsg);
			Action->SetReadyToDestroy();
		});
	return Action;
}
