﻿#pragma once
#include "Relationship/Friend/Data/CsdkFriendApply.h"
#include "Relationship/Friend/Data/CsdkOperateFriendApplyResult.h"
#include "User/Data/CsdkUserId.h"

class FFriendApplyManager
{
public:
	void Init();
	void Clear();
	void GetFriendApplyList(
		const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg,const TArray<FCsdkFriendApply>& ApplyList)>& Callback);
	void GetFriendApplyListRemote(
			const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg,const TArray<FCsdkFriendApply>& ApplyList)>& Callback = nullptr);
	void AgreeFriendApply(const TArray<FString>& ApplyTokens,
		const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg,const TArray<FCsdkOperateFriendApplyResult>& AgreeListResult )>& Callback);
	void RefuseFriendApply(const TArray<FString>& ApplyTokens,
	const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg,const TArray<FCsdkOperateFriendApplyResult>& RefuseListResult )>& Callback);
	void OnFriendApplied(const FString& JsonData);
	//获取未读数
	int32 GetUnreadCount();
	//清除未读数
	void ClearUnreadCount();
	//移除申请
	void TryRemoveApply(const FCsdkUserId& FriendId);

private:
	bool LoadUnreadCountFile();
	bool SaveApplyUsersToFile();
	static FString GetSavePath();
	void RemoveFriendApply(const TArray<FString>& InTokens);
	//变更未读数
	void UpdateFriendApply(const FCsdkFriendApply& FriendApply);

private:
	bool bIsPull = false;
	using FApply2Read = TPair<FCsdkFriendApply,bool>;
	TMap<FCsdkUserId,FApply2Read> UserId2ApplyMap;
	TMap<FString,FCsdkUserId> Token2UserIds;
	
};


