#pragma once

#include "SessionList.h"
#include "Session/Data/CsdkSessionId.h"

class FSessionManager
{
public:
	void Init();
	void Reset();
	
	UCsdkSession* GetSessionById(const FCsdkSessionId& SessionId) const;
	UCsdkSession* CreateOrUpdateSession(const FCsdkSessionId& SessionId, UCsdkMessageBase* LastMsg = nullptr);
	UCsdkSession* FindSession(const FCsdkSessionId& SessionId) const;
	void DeleteSession( const FCsdkSessionId& SessionId, const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg)>& Callback );
	void RemoveLocalSession( const FCsdkSessionId& SessionId );
	void GetSessionList( TFunction<void(const int32 ErrorCode,const FString& ErrorMsg,TArray<UCsdkSession*>)> Callback);
	void PinSession( const FCsdkSessionId& SessionId,const	bool bIsPinned, const TFunction<void(const int32 ErrorCode, const FString& ErrorMsg,const FDateTime& PinnedTime)>& Callback);
	
	int32 GetUnreadCount(const FCsdkSessionId& SessionId);
	int32 GetAllUnreadCount();
	void ClearUnreadCount(const FCsdkSessionId& SessionId);
	void AddNotPrivateChatUnreadCount(const FCsdkSessionId& SessionId,int32 IncreaseCount);
private:
	bool LoadLastReadSeq();
	bool SaveLastReadSeqToFile();
	int32 GetPrivateChatUnreadCount(const FCsdkSessionId& SessionId);
	int32 GetNotPrivateChatUnreadCount(const FCsdkSessionId& SessionId);
	void ClearPrivateChatUnreadCount(const FCsdkSessionId& SessionId);
	void ClearNotPrivateChatUnreadUnreadCount(const FCsdkSessionId& SessionId);
	static FString GetSavePath();
private:
	FSessionList LocalSessionList;
	TMap<FCsdkSessionId,int32> PrivateChatLastReadSequence;
	TMap<FCsdkSessionId,int32> NotPrivateChatId2UnreadCount;
	static const FString UnReadCountPath;
	static const FString ReceiverIdKey;
	static const FString ServerIdKey;
	static const FString SessionTypeKey;
	static const FString LastReadMsgSeqKey;
};



