#include "Session/CsdkGetSessionList.h"
#include "Tools/CsdkCommonTools.h"


UCsdkGetSessionList* UCsdkGetSessionList::GetSessionList(UObject* WorldContextObject)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkGetSessionList* Action = NewObject<UCsdkGetSessionList>();
	Action->RegisterWithGameInstance(WorldContextObject);
	return Action;
}

void UCsdkGetSessionList::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetSessionManager().GetSessionList(
	[this](const int32 ErrorCode, const FString& ErrorMsg,const TArray<UCsdkSession*>& SessionList)
	{
		if(!IsValidLowLevel())
			return;
		
		this->Completed.Broadcast(ErrorCode,ErrorMsg,SessionList);
		this->SetReadyToDestroy();
	});
}
