#include "Session/CsdkPinSession.h"

#include "ChatRoom/CsdkQuitChatRoom.h"
#include "Tools/CsdkCommonTools.h"

UCsdkPinSession* UCsdkPinSession::PinSession(UObject* WorldContextObject, const FCsdkSessionId& SessionId,
	const bool bIsPinned)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkPinSession* Action = NewObject<UCsdkPinSession>();
	Action->RegisterWithGameInstance(WorldContextObject);
	Action->MySessionId = SessionId;
	Action->bMyIsPinned = bIsPinned;
	return Action;
}

void UCsdkPinSession::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetSessionManager().PinSession(MySessionId,bMyIsPinned,
		[this](const int32 ErrorCode,const FString& ErrorMsg,const FDateTime& DateTime)
		{
			if(!IsValidLowLevel())
				return;
			
			this->Completed.Broadcast(ErrorCode,ErrorMsg,DateTime);
			this->SetReadyToDestroy();
		});
}


