#include "Session/CsdkSessionLibrary.h"

#include "Manager/CsdkSubsystem.h"
#include "Tools/CsdkCommonTools.h"


FString UCsdkSessionLibrary::Conv_SessionIdToString(const FCsdkSessionId& SessionId)
{
#if UE_SERVER	
	return {};
#endif
	return SessionId.ToString();
}

FCsdkSessionId UCsdkSessionLibrary::Conv_RoomIdToSessionId(const FCsdkChatRoomId& RoomId)
{
#if UE_SERVER	
	return {};
#endif
	FCsdkSessionId SessionId;
	SessionId.ReceiverId = RoomId.CustomId;
	SessionId.ServerId = RoomId.ServerId;
	SessionId.Type = ECsdkSessionType::ChatRoom;
	return SessionId;
}

FCsdkSessionId UCsdkSessionLibrary::Conv_UserIdToSessionId(const FCsdkUserId& UserId)
{
#if UE_SERVER	
	return {};
#endif
	FCsdkSessionId SessionId;
	SessionId.ReceiverId = UserId.RoleId;
	SessionId.ServerId = UserId.ServerId;
	SessionId.Type = ECsdkSessionType::PrivateChat;
	return SessionId;
}

UCsdkSession* UCsdkSessionLibrary::CreateSession(const FCsdkSessionId& SessionId)
{
#if UE_SERVER	
	return {};
#endif
	return FCsdkCommonTools::GetSessionManager().CreateOrUpdateSession(SessionId,nullptr);
}

UCsdkSession* UCsdkSessionLibrary::FindSession(const FCsdkSessionId& SessionId)
{
#if UE_SERVER	
	return {};
#endif
	return FCsdkCommonTools::GetSessionManager().FindSession(SessionId);
}

int32 UCsdkSessionLibrary::GetUnreadCount(const FCsdkSessionId& SessionId)
{
#if UE_SERVER	
	return {};
#endif
	return FCsdkCommonTools::GetSessionManager().GetUnreadCount(SessionId);
}

int32 UCsdkSessionLibrary::GetAllUnreadCount()
{
#if UE_SERVER	
	return {};
#endif
	return FCsdkCommonTools::GetSessionManager().GetAllUnreadCount();
}

void UCsdkSessionLibrary::ClearUnreadCount(const FCsdkSessionId& SessionId)
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetSessionManager().ClearUnreadCount(SessionId);
}


