#include "User/CsdkGetUser.h"
#include "Tools/CsdkCommonTools.h"


UCsdkGetUser* UCsdkGetUser::GetUserInfo(UObject* WorldContextObject,
                                   const FCsdkUserId& UserIdList)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkGetUser* Action = NewObject<UCsdkGetUser>();
	Action->RegisterWithGameInstance(WorldContextObject);
	
	Action->UserId = UserIdList;
	return Action;
}

void UCsdkGetUser::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetUserManager().GetUserList({UserId},
	[this](const int32 ErrorCode, const FString& ErrorMsg, const TArray<FCsdkUser>& UserList)
	{
		if(!this->IsValidLowLevel())
			return;

		if (UserList.IsValidIndex(0))
		{
			this->Completed.Broadcast(ErrorCode,ErrorMsg,UserList[0]);

		}
		this->SetReadyToDestroy();
	});
}
