﻿#include "User/CsdkGetUserListStatus.h"
#include "User/CsdkGetUserList.h"
#include "Tools/CsdkCommonTools.h"


UCsdkGetUserListStatus* UCsdkGetUserListStatus::GetUserListStatus(UObject* WorldContextObject,
									const TArray<FCsdkUserId>& UserIds)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkGetUserListStatus* Action = NewObject<UCsdkGetUserListStatus>();
	Action->RegisterWithGameInstance(WorldContextObject);
	
	Action->UserIds = UserIds;
	return Action;
}

void UCsdkGetUserListStatus::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetUserManager().GetUserListStatus(UserIds,
	[this](const int32 ErrorCode, const FString& ErrorMsg, const TArray<FCsdkUserStatusResult>& StatusResultList)
	{
		this->Completed.Broadcast(ErrorCode, ErrorMsg, StatusResultList);
		this->SetReadyToDestroy();
	});
}
