﻿#include "User/CsdkGetUserStatus.h"
#include "User/CsdkGetUserList.h"
#include "Tools/CsdkCommonTools.h"


UCsdkGetUserStatus* UCsdkGetUserStatus::GetUserStatus(UObject* WorldContextObject,
									const FCsdkUserId& UserId)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkGetUserStatus* Action = NewObject<UCsdkGetUserStatus>();
	Action->RegisterWithGameInstance(WorldContextObject);
	
	Action->UserId = UserId;
	return Action;
}

void UCsdkGetUserStatus::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetUserManager().GetUserListStatus({UserId},
	[this](const int32 ErrorCode, const FString& ErrorMsg, const TArray<FCsdkUserStatusResult>& StatusResultList)
	{
		if (StatusResultList.IsValidIndex(0))
		this->Completed.Broadcast(ErrorCode, ErrorMsg, StatusResultList[0]);
		this->SetReadyToDestroy();
	});
}
