﻿
#include "User/CsdkSearchUser.h"

#include "User/CsdkUpdateUser.h"
#include "Tools/CsdkCommonTools.h"


UCsdkSearchUser* UCsdkSearchUser::SearchUser(UObject* WorldContextObject, const TArray<FCsdkUserSearchCondition>& Conditions, const int32 PageNo, const int32 PageSize)
{
#if UE_SERVER	
	return {};
#endif
#if CSDK_WITH_CHECK
	checkf(FCsdkCommonTools::HasLogin(),TEXT("CSDK may not login"))
#endif
	UCsdkSearchUser* Action = NewObject<UCsdkSearchUser>();
	Action->RegisterWithGameInstance(WorldContextObject);
	
	Action->Conditions = Conditions;
	Action->PageNo = PageNo;
	Action->PageSize = PageSize;
	return Action;
}

void UCsdkSearchUser::Activate()
{
#if UE_SERVER	
	return;
#endif
	FCsdkCommonTools::GetUserManager().SearchUser(Conditions, PageNo, PageSize,
	[this](const int32 ErrorCode,const FString& ErrorMsg, const TArray<FCsdkUser>& UserList)
	{
		if(!this->IsValidLowLevel())
			return;
		
		this->Completed.Broadcast(ErrorCode,ErrorMsg, UserList);
		this->SetReadyToDestroy();
	});
}
