#include "UserTool.h"

#include "User/Data/CsdkUserControl.h"

FCsdkUser CsdkUserTool::ConvertUser(const heroim::client::v3beta::dto::user::model::User& PbUserBase)
{
	FCsdkUser CsdkUser;
	CsdkUser.Id = {STD_STRING_TO_FSTRING(PbUserBase.userkey().roleid()), STD_STRING_TO_FSTRING(PbUserBase.userkey().serverid())};
	CsdkUser.RoleName = STD_STRING_TO_FSTRING(PbUserBase.rolename());
	CsdkUser.AvatarUrl = STD_STRING_TO_FSTRING(PbUserBase.avatarurl());
	CsdkUser.Gender = static_cast<ECsdkGender>(PbUserBase.gender());
	CsdkUser.Version =PbUserBase.version();
	for (const auto& ExtraItem : PbUserBase.extra())
	{
		CsdkUser.Extra.Add(STD_STRING_TO_FSTRING(ExtraItem.first),STD_STRING_TO_FSTRING(ExtraItem.second));
	}
	return CsdkUser;
}

FCsdkUser CsdkUserTool::ConvertUser(const heroim::client::v3beta::dto::user::model::UserSimple& PbMessageUser)
{
	FCsdkUser CsdkUser;
	CsdkUser.Id = {STD_STRING_TO_FSTRING(PbMessageUser.roleid()), STD_STRING_TO_FSTRING(PbMessageUser.serverid())};
	CsdkUser.RoleName = STD_STRING_TO_FSTRING(PbMessageUser.rolename());
	CsdkUser.AvatarUrl = STD_STRING_TO_FSTRING(PbMessageUser.avatarurl());
	CsdkUser.Gender = static_cast<ECsdkGender>(PbMessageUser.gender());
	CsdkUser.Version =PbMessageUser.version();
	for (const auto& ExtraItem : PbMessageUser.extra())
	{
		CsdkUser.Extra.Add(STD_STRING_TO_FSTRING(ExtraItem.first),STD_STRING_TO_FSTRING(ExtraItem.second));
	}
	return CsdkUser;
}

FCsdkUser CsdkUserTool::ConvertUser(const TSharedPtr<FJsonObject>& UserObject)
{
	FCsdkUser CsdkUser;
	FString RoleId, ServerId;
	int32 Gender;
	UserObject->TryGetStringField(TEXT("roleId"), RoleId);
	UserObject->TryGetStringField(TEXT("serverId"), ServerId);
	CsdkUser.Id = {RoleId, ServerId};
	UserObject->TryGetStringField(TEXT("roleName"), CsdkUser.RoleName);
	UserObject->TryGetStringField(TEXT("avatarUrl"), CsdkUser.AvatarUrl);
	UserObject->TryGetNumberField(TEXT("gender"), Gender);
	CsdkUser.Gender = static_cast<ECsdkGender>(Gender);
	UserObject->TryGetNumberField(TEXT("version"), CsdkUser.Version);
	const TSharedPtr<FJsonObject>* TempExtra;
	if (UserObject->TryGetObjectField(TEXT("extra"), TempExtra) && TempExtra)
	{
		for (auto It = (*TempExtra)->Values.CreateConstIterator(); It; ++It)
		{
			CsdkUser.Extra.Add(It.Key(), *It.Value()->AsString());
		}
	}
	return CsdkUser;
}

FCsdkUserStatus CsdkUserTool::ConvertUserStatus(const TSharedPtr<FJsonObject>& UserStatusObj)
{
	FCsdkUserStatus UserStatus;
	bool IsOnline = false;
	int64 LastOnlineTime = 0;
	UserStatusObj->TryGetBoolField(TEXT("isOnline"), IsOnline);
	UserStatusObj->TryGetNumberField(TEXT("lastOnlineTime"), LastOnlineTime);
	const TSharedPtr<FJsonObject>* TempExtra;
	if (UserStatusObj->TryGetObjectField(TEXT("extra"), TempExtra) && TempExtra)
	{
		for (auto It = (*TempExtra)->Values.CreateConstIterator(); It; ++It)
		{
			UserStatus.Extra.Add(It.Key(), *It.Value()->AsString());
		}
	}
	const FDateTime LastOnlineTimeObj = FDateTime::FromUnixTimestamp(LastOnlineTime / 1000);
	UserStatus.bIsOnline = IsOnline;
	UserStatus.LastOnlineTime = LastOnlineTimeObj;
	return UserStatus;
}

void CsdkUserTool::ConvertControlStatus(const TSharedPtr<FJsonObject>& ControlStatusObj, FCsdkUserControl& CsdkUserControl)
{
	int32 Message = 0;
	int32 Talk = 0;
	int64 MessageControlEndTime = 0;
	FString MessageControlReason;

	int64 VoiceControlEndTime = 0;
	FString VoiceControlReason;
	//被禁言为1
	ControlStatusObj->TryGetNumberField(TEXT("message"), Message);
	ControlStatusObj->TryGetNumberField(TEXT("talk"), Talk);

	if (ControlStatusObj->HasField(TEXT("messageDetail")))
	{
		TSharedPtr<FJsonObject> MessageDetailObject = ControlStatusObj->GetObjectField(TEXT("messageDetail"));
		if (MessageDetailObject->HasField(TEXT("endTime")))
		{
			MessageDetailObject->TryGetNumberField(TEXT("endTime"), MessageControlEndTime);
		}
		if (MessageDetailObject->HasField(TEXT("reason")))
		{
			MessageDetailObject->TryGetStringField(TEXT("reason"), MessageControlReason);
		}
	}

	if (ControlStatusObj->HasField(TEXT("talkDetail")))
	{
		TSharedPtr<FJsonObject> VoiceDetailObject = ControlStatusObj->GetObjectField(TEXT("talkDetail"));
		if (VoiceDetailObject->HasField(TEXT("endTime")))
		{
			VoiceDetailObject->TryGetNumberField(TEXT("endTime"), VoiceControlEndTime);
		}
		if (VoiceDetailObject->HasField(TEXT("reason")))
		{
			VoiceDetailObject->TryGetStringField(TEXT("reason"), VoiceControlReason);
		}
	}
	
	CsdkUserControl.bCanSendMsg = !Message;
	CsdkUserControl.bCanSendVoice = !Talk;
	
	CsdkUserControl.MessageControlDetail.EndTime = FDateTime::FromUnixTimestamp(MessageControlEndTime / 1000);
	CsdkUserControl.MessageControlDetail.Reason = MessageControlReason;
	
	CsdkUserControl.VoiceControlDetail.EndTime = FDateTime::FromUnixTimestamp(VoiceControlEndTime / 1000);
	CsdkUserControl.VoiceControlDetail.Reason = VoiceControlReason;
}
