﻿// Fill out your copyright notice in the Description page of Project Settings.


#include "Voice/CsdkVoiceBase.h"
#include "Manager/CsdkVoiceSupportSubsystem.h"

bool UCsdkVoiceBase::Init(UCsdkVoiceSupportSubsystem* CsdkVoiceSupportSubsystem)
{
#if UE_SERVER	
	return {};
#endif
	VoiceSupportSubsystem = CsdkVoiceSupportSubsystem;
	return false;
}

int32 UCsdkVoiceBase::UnInit()
{
#if UE_SERVER	
	return {};
#endif
	if(TickerHandle.IsValid())
	{
		CSDK_Ticker::GetCoreTicker().RemoveTicker(TickerHandle);
		TickerHandle.Reset();
	}
	return 0;
}

TMap<FString, FUploadRecordedFileCompleted>& UCsdkVoiceBase::GetUploadCallbackMap()
{
	static TMap<FString, FUploadRecordedFileCompleted> UploadCallbackMap;
	return UploadCallbackMap;
}


TMap<FString, FDownloadRecordedFileCompleted>& UCsdkVoiceBase::GetDownloadCallbackMap()
{
	static TMap<FString, FDownloadRecordedFileCompleted> DownloadCallbackMap;
	return DownloadCallbackMap;
}

TMap<FString, FPlayRecordedFileCompleted>& UCsdkVoiceBase::GetPlayCallbackMap()
{
	static TMap<FString, FPlayRecordedFileCompleted> PlayCallbackMap;
	return PlayCallbackMap;
}

TMap<FString, FSpeechToTextCompleted>& UCsdkVoiceBase::GetSpeechToTextCallbackMap()
{
	static TMap<FString, FSpeechToTextCompleted> SpeechToTextCallbackMap;
	return SpeechToTextCallbackMap;
}


TMap<FString, FStreamSpeechToTextCompleted>& UCsdkVoiceBase::GetStreamSpeechToTextCompletedCallbackMap()
{
	static TMap<FString, FStreamSpeechToTextCompleted> StreamSpeechToTextCompletedCallbackMap;
	return StreamSpeechToTextCompletedCallbackMap;
}

FString UCsdkVoiceBase::GetRecordingFileName()
{
#if UE_SERVER	
	return {};
#endif
	return TEXT("None");
}

FString UCsdkVoiceBase::GetDownloadFilePath()
{
#if UE_SERVER	
	return {};
#endif
	return TEXT("None");
}

FString UCsdkVoiceBase::GetFileStorePath()
{
#if UE_SERVER	
	return {};
#endif
#if PLATFORM_ANDROID
	extern FString GExternalFilePath;
	FString RootPath = GExternalFilePath + FString("/");
#elif PLATFORM_IOS || PLATFORM_MAC
	FString RootPath = FString::Printf(TEXT("%s%s"),UTF8_TO_TCHAR(getenv("HOME")),TEXT("/Documents/"));
#else
	FString RootPath = FPaths::Combine( FPaths::ProjectSavedDir(), TEXT("Csdk"));
#endif
	const FString StorePath = FPaths::Combine(RootPath,TEXT("CsdkVoice"));
	if(!FPlatformFileManager::Get().GetPlatformFile().DirectoryExists(*StorePath))
	{
		FPlatformFileManager::Get().GetPlatformFile().CreateDirectoryTree(*StorePath);
	}
	return FPaths::ConvertRelativePathToFull(StorePath);
}
