// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Data/CsdkChatRoomInfo.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "CsdkJoinChatRoomAutoCreate.generated.h"


DECLARE_DYNAMIC_MULTICAST_DELEGATE_ThreeParams(FCsdkJoinChatRoomAutoCreateResult,const int32,ErrorCode,const FString&, ErrorMsg,const FCsdkChatRoomInfo&, ChatRoomInfo);

/**#
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkJoinChatRoomAutoCreate : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 加入一个聊天室，如果该聊天室不存在则自动创建该聊天室
	 * @param WorldContextObject 
	 * @param RoomId 聊天室Id
	 * @param Param 辅助参数，如聊天室的名称头像等参数
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|ChatRoom")
	static UCsdkJoinChatRoomAutoCreate* JoinChatRoomAutoCreate(UObject* WorldContextObject,const FCsdkChatRoomId& RoomId,const  FCsdkChatRoomCreateParam& Param);

	virtual void Activate() override;
	
	UPROPERTY(BlueprintAssignable)
	FCsdkJoinChatRoomAutoCreateResult Completed;

private:
	FCsdkChatRoomId ChatRoomId;
	FCsdkChatRoomCreateParam CreateRoomParam;
};


