// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Data/CsdkChatRoomId.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "CsdkQuitChatRoom.generated.h"


DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FCsdkQuitChatRoomResult,const int32,ErrorCode,const FString&, ErrorMsg);

/**#
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkQuitChatRoom : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 退出聊天室
	 * @param WorldContextObject 
	 * @param RoomId 聊天室ID
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|ChatRoom")
	static UCsdkQuitChatRoom* QuitChatRoom(UObject* WorldContextObject,const FCsdkChatRoomId& RoomId);
	
	virtual void Activate() override;
	
	UPROPERTY(BlueprintAssignable)
	FCsdkQuitChatRoomResult Completed;
	
private:
	FCsdkChatRoomId ChatRoomId;
};


