﻿
#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "Data/ReportToHeroParams.h"
#include "CsdkAccuseToHeroSentiment.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FCsdkAccuseToHeroSentimentResult, const int32, ErrorCode, const FString&, ErrorMsg);

/**#
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkAccuseToHeroSentiment : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 举报用户
	 * @param WorldContextObject 
	 * @param AccuseParam 举报参数
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Consensus")
	static UCsdkAccuseToHeroSentiment* Accuse(UObject* WorldContextObject, const FCsdkAccuseToSentimentParam& AccuseParam);

	virtual void Activate() override;
	
	UPROPERTY(BlueprintAssignable)
	FCsdkAccuseToHeroSentimentResult Completed;

private:
	FCsdkAccuseToSentimentParam AccuseToHeroParam;
};
