﻿#pragma once
#include "JsonObjectConverter.h"
#include "CoreMinimal.h"
#include "ReportToHeroParams.generated.h"

USTRUCT(BlueprintType)
struct FCsdkSensitiveTextCheckParam
{
	GENERATED_BODY()

	// 如果出现非法字段是否上报
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|Consensus")
	bool Enabled = false;

	// 上报类型
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|Consensus")
	int32 Type = -1;

	// 频道ID
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|Consensus")
	int32 ChannelId = -1;

	// 扩展字段
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|Consensus")
	TMap<FString, FString> ExtendItems;

	FString ToString() const
	{
		FString Result;
		FJsonObjectConverter::UStructToJsonObjectString(*this,Result);
		return Result;
	}
};

USTRUCT(BlueprintType)
struct FCsdkAccuseToSentimentParam
{
	GENERATED_BODY()

	// 被举报者区服ID 必须
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|Consensus")
	int32 ServerId = -1;

	// 被举报者角色ID 必须
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|Consensus")
	FString RoleId;

	// 被举报者角色名 非必须
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|Consensus")
	FString RoleName;

	// 被举报者等级 非必须
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|Consensus")
	int32 Level = -1;

	// 平台(1:IOS，2:安卓，3: 混服) 非必须
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|Consensus")
	int32 Platform =-1;

	// 被举报者vip等级 非必须
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|Consensus")
	int32 VipLevel = -1;
	
	// 内容 必须
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|Consensus")
	FString Text;

	// 举报人备注内容 非必须
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|Consensus")
	FString Remark;
	
	// 举报原因(举报分类名称，如: 发布广告。多个用英文分号分割) 非必须
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|Consensus")
	FString Reason;

	FString ToString() const
	{
		FString Result;
		FJsonObjectConverter::UStructToJsonObjectString(*this,Result);
		return Result;
	}
};
