// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "CsdkAuthCodeLogin.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FCsdkAuthCodeLoginCallBack,const int32,ErrorCode, const FString&, ErrorMsg);

/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkAuthCodeLogin : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 
	 * @param WorldContextObject 上下文环境
	 * @param AuthCode 授权码
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Login")
	static UCsdkAuthCodeLogin* CsdkAuthCodeLogin(UObject* WorldContextObject, const FString& AuthCode);

	virtual void Activate() override;
	
	/**
	 * @brief 回调
	 */
	UPROPERTY(BlueprintAssignable)
	FCsdkAuthCodeLoginCallBack Completed;

private:
	FString AuthCode;
};
