// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Subsystems/GameInstanceSubsystem.h"
#include "Session/Data/CsdkSessionId.h"
#include "User/Data/CsdkUser.h"
#include "User/Data/CsdkUserId.h"
#include "User/Data/CsdkUserStatus.h"
#include "Relationship/Block/Data/CsdkBlock.h"
#include "ChatRoom/Data/CsdkChatRoomInfo.h"
#include "Session/Data/CsdkSession.h"
#include "Session/Data/CsdkSessionChanged.h"
#include "Relationship/Friend/Data/CsdkFriendApply.h"
#include "User/Data/CsdkUserControl.h"
#include "CsdkSubsystem.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FOnFriendApplied,const FCsdkUser&,FromUser,const FCsdkFriendApply&, FriendApplyInfo);
DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FOnFriendAddSuccess,const FCsdkUser&,FromUser,const FCsdkUser&,TargetUser);
DECLARE_DYNAMIC_MULTICAST_DELEGATE_OneParam(FOnFriendDeleteSelf,const FCsdkUser&,FromUser);
DECLARE_DYNAMIC_MULTICAST_DELEGATE_OneParam(FOnBlockAdd,const FCsdkBlock&,BlockInfo);
DECLARE_DYNAMIC_MULTICAST_DELEGATE_OneParam(FOnBlockDeleted,const FCsdkUserId&,UserId);
DECLARE_DYNAMIC_MULTICAST_DELEGATE_OneParam(FOnUserProfileChanged, const FCsdkUser&, User);
DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FOnUserStatusChanged, const FCsdkUserId&, UserId, const FCsdkUserStatus&, UserStatus);
DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FOnSessionChanged,const ECsdkSessionChanged::Type, Type,UCsdkSession*,NewSession);
DECLARE_DYNAMIC_MULTICAST_DELEGATE(FOnKickOff);
DECLARE_DYNAMIC_MULTICAST_DELEGATE_OneParam(FOnChatRoomJoin,const FCsdkChatRoomInfo&,RoomInfo);
DECLARE_DYNAMIC_MULTICAST_DELEGATE_OneParam(FOnBeChatRoomRemoved,const FCsdkChatRoomInfo&,RoomInfo);
DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FOnChatRoomDismissed,const FCsdkChatRoomInfo&,RoomInfo,const FCsdkUser&,Operator);
DECLARE_DYNAMIC_MULTICAST_DELEGATE_OneParam(FOnControlStatusChanged, const FCsdkUserControl&, CsdkUserControl);
DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FOnNewMessagesReceived,const FCsdkSessionId&,SessionId,const TArray<UCsdkMessageBase*>&,NewMsgs);
DECLARE_DYNAMIC_MULTICAST_DELEGATE(FOnReconnect);
DECLARE_DYNAMIC_MULTICAST_DELEGATE(FOnDisconnect);
DECLARE_DYNAMIC_MULTICAST_DELEGATE(FOnFriendApplyUnreadCountChanged);
DECLARE_DYNAMIC_MULTICAST_DELEGATE_OneParam(FOnSessionUnreadCountChanged,const FCsdkSessionId&,SessionId);
DECLARE_DYNAMIC_MULTICAST_DELEGATE_OneParam(FOnClearSessionMsg,const FCsdkSessionId&,SessionId);

/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkSubsystem : public UGameInstanceSubsystem
{
	GENERATED_BODY()
	DECLARE_DYNAMIC_DELEGATE_TwoParams(FCsdkLoginCallBack,const int32, ErrorCode,const FString&, ErrorMsg);
public:
	virtual void Initialize(FSubsystemCollectionBase& Collection) override;
	virtual void Deinitialize() override;
	
	/**
	 * @brief 好友申请通知
	 */
	UPROPERTY(BlueprintAssignable,Category="CSDK|Relationship")
	FOnFriendApplied OnFriendApplied;
	/**
	 * @brief 好友添加成功通知
	 */
	UPROPERTY(BlueprintAssignable,Category="CSDK|Relationship")
	FOnFriendAddSuccess OnFriendAddSuccess;
	/**
	 * @brief 好友删除自己成功通知
	 */
	UPROPERTY(BlueprintAssignable,Category="CSDK|Relationship")
	FOnFriendDeleteSelf OnFriendDeleteSelf;
	UPROPERTY(BlueprintAssignable,Category="CSDK|Relationship")
	FOnBlockAdd OnBlockAdd;
	UPROPERTY(BlueprintAssignable,Category="CSDK|Relationship")
	FOnBlockDeleted OnBlockDeleted;
	UPROPERTY(BlueprintAssignable,Category="CSDK|Relationship")
	FOnFriendApplyUnreadCountChanged OnFriendApplyUnreadCountChanged;
	/**
	 * @brief 用户资料变更通知，目前仅限好友
	 */
	UPROPERTY(BlueprintAssignable,Category="CSDK|User")
	FOnUserProfileChanged OnUserProfileChanged;
	/**
	 * @brief 用户状态变更通知，目前仅限好友
	 */
	UPROPERTY(BlueprintAssignable,Category="CSDK|User")
	FOnUserStatusChanged OnUserStatusChanged;
	UPROPERTY(BlueprintAssignable,Category="CSDK|User")
	FOnControlStatusChanged OnControlStatusChanged;
	/**
	 * @brief 新消息通知
	 */
	UPROPERTY(BlueprintAssignable,Category="CSDK|Message")
	FOnNewMessagesReceived OnNewMessagesReceived;
	/**
	 * @brief 会话变更事件
	 */
	UPROPERTY(BlueprintAssignable,Category="CSDK|Session")
	FOnSessionChanged OnSessionChanged;
	/**
	 * @brief 会话未读数变更通知
	 */
	UPROPERTY(BlueprintAssignable,Category="CSDK|Session")
	FOnSessionUnreadCountChanged OnSessionUnreadCountChanged;
	

	/**
	 * @brief 加入聊天室通知
	 */
	UPROPERTY(BlueprintAssignable,Category="CSDK|ChatRoom")
	FOnChatRoomJoin OnChatRoomJoin;
	/**
	 * @brief 被移除聊天室通知
	 */
	UPROPERTY(BlueprintAssignable,Category="CSDK|ChatRoom")
	FOnBeChatRoomRemoved OnBeChatRoomRemoved;
	/**
	 * @brief 聊天室解散通知
	 */
	UPROPERTY(BlueprintAssignable,Category="CSDK|ChatRoom")
	FOnChatRoomDismissed OnChatRoomDismissed;
	/**
	* @brief 聊天SDK断开登录链接通知
	*/
	UPROPERTY(BlueprintAssignable,Category="CSDK|LoginState")
	FOnDisconnect OnDisconnect;
	/**
	 * @brief 聊天SDK登录重连成功通知
	 */
	UPROPERTY(BlueprintAssignable,Category="CSDK|LoginState")
	FOnReconnect OnReconnect;
	/**
	 * @brief 被踢下线通知
	 */
	UPROPERTY(BlueprintAssignable,Category="CSDK|LoginState")
	FOnKickOff OnKickOff;

	/**
	 * @brief 清空会话数据
	 */
	UPROPERTY(BlueprintAssignable,Category="CSDK|LoginState")
	FOnClearSessionMsg OnClearSessionMsg;
};
