﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "CsdkMessageBase.h"
#include "ChatRoom/Data/CsdkChatRoomInfo.h"
#include "CsdkEventMessage.generated.h"

/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkEventMessage : public UCsdkMessageBase
{
	GENERATED_BODY()
public:
	UPROPERTY(EditAnywhere,BlueprintReadOnly,Category= "Csdk|Message")
	ECsdkEventMessageType EventType = ECsdkEventMessageType::Invalid;

	UFUNCTION(BlueprintCallable,Category="CSDK|Message")
	bool GetFriendAddedInfo(FCsdkUser& FromUser,FCsdkUser& DistUser);
	UFUNCTION(BlueprintCallable,Category="CSDK|Message")
	bool GetChatRoomCreateInfo(FCsdkUser& Creator,FCsdkChatRoomInfo& RoomInfo);
	UFUNCTION(BlueprintCallable,Category="CSDK|Message")
	bool GetChatRoomJoinedInfo(FCsdkUser& User,FCsdkChatRoomInfo& RoomInfo);
	UFUNCTION(BlueprintCallable,Category="CSDK|Message")
	bool GetChatRoomQuitedInfo(FCsdkUser& User,FCsdkChatRoomInfo& RoomInfo);
	UFUNCTION(BlueprintCallable,Category="CSDK|Message")
	bool GetChatRoomMemberRemovedInfo(FCsdkUser& Operator,FCsdkUser& DistUser,FCsdkChatRoomInfo& RoomInfo);
	UFUNCTION(BlueprintCallable,Category="CSDK|Message")
	bool GetChatRoomDismissedInfo(FCsdkUser& Operator,FCsdkChatRoomInfo& RoomInfo);

	void SetData(const FString& InData);
private:
	FString Data;
};

