﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Message/Data/CsdkMessageStatus.h"
#include "Message/Data/CsdkMessageType.h"

#include "UObject/Object.h"
#include "User/Data/CsdkUser.h"
#include "CsdkMessageBase.generated.h"

/**
 * 
 */
UCLASS(Abstract,BlueprintType)
class CSDKRUNTIME_API UCsdkMessageBase : public UObject
{
	GENERATED_BODY()
public:
	UPROPERTY(EditAnywhere,BlueprintReadOnly,Category= "Csdk|Message")
	FString MsgId;
	UPROPERTY(EditAnywhere,BlueprintReadOnly,Category= "Csdk|Message")
	FString ClientMsgId;
	UPROPERTY(EditAnywhere,BlueprintReadOnly,Category= "Csdk|Message")
	ECsdkMessageType MsgType =ECsdkMessageType::Invalid;
	UPROPERTY(EditAnywhere,BlueprintReadOnly,Category= "Csdk|Message")
	FDateTime Time;
	UPROPERTY(EditAnywhere,BlueprintReadOnly,Category= "Csdk|Message")
	TEnumAsByte<ECsdkMessageStatus::Type>  Status = ECsdkMessageStatus::Normal;
	UPROPERTY(EditAnywhere,BlueprintReadOnly,Category= "Csdk|Message")
	int32 Sequence = -1;
	UPROPERTY(EditAnywhere,BlueprintReadOnly,Category= "Csdk|Message")
	FCsdkUser Sender;
	UPROPERTY(EditAnywhere,BlueprintReadOnly,Category= "Csdk|Message")
	bool bIsSelf = false;
	UPROPERTY(EditAnywhere,BlueprintReadOnly,Category= "Csdk|Message")
	TMap<FString,FString> Extra;
};
