// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "Data/CsdkBlock.h"
#include "CsdkGetBlockList.generated.h"


DECLARE_DYNAMIC_MULTICAST_DELEGATE_ThreeParams(FCsdkGetBlockListResult,const int32,ErrorCode,const FString&,ErrorMsg,const TArray<FCsdkBlock>&,BlockList);

/**#
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkGetBlockList : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 获取黑名单列表
	 * @param WorldContextObject 上下文
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Relationship|Block")
		static UCsdkGetBlockList* GetBlockList(UObject* WorldContextObject);
	
	virtual void Activate() override;
	
	UPROPERTY(BlueprintAssignable)
	FCsdkGetBlockListResult Completed;
};
