// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "User/Data/CsdkUserId.h"
#include "Data/CsdkOperateFriendApplyResult.h"
#include "CsdkFriendApplyOperate.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FCsdkFriendApplyOperateCallback, const int32,ErrorCode,const FString&,ErrorMsg);


/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkFriendApplyOperate : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:

	/**
	 * @brief 同意好友申请
	 * @param WorldContextObject 
	 * @param Token 好友申请记录码
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Relationship|FriendApply")
	static UCsdkFriendApplyOperate* AgreeFriendApply(UObject* WorldContextObject, const FString& Token);
	
	/**
	 * @brief 拒绝好友申请
	 * @param WorldContextObject 
	 * @param Token 好友申请记录码
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Relationship|FriendApply")
	static UCsdkFriendApplyOperate* RefuseFriendApply(UObject* WorldContextObject,const FString& Token);

	
	UPROPERTY(BlueprintAssignable)
	FCsdkFriendApplyOperateCallback Completed;
	
};

