// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "Data/CsdkFriend.h"
#include "CsdkGetFriendList.generated.h"


DECLARE_DYNAMIC_MULTICAST_DELEGATE_ThreeParams(FCsdkGetFriendListResult,const int32,ErrorCode,const FString&,ErrorMsg,const TArray<FCsdkFriend>&,FriendInfoList);

/**#
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkGetFriendList : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 获取好友列表
	 * @param WorldContextObject 上下文
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Relationship|Friend")
	static UCsdkGetFriendList* GetFriendList(UObject* WorldContextObject);

	UPROPERTY(BlueprintAssignable)
	FCsdkGetFriendListResult Completed;


};
