// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "User/Data/CsdkUserId.h"
#include "Relationship/Friend/Data/CsdkFriendDelResult.h"
#include "CsdkOperateFriendList.generated.h"


DECLARE_DYNAMIC_MULTICAST_DELEGATE_ThreeParams(FCsdkOperateFriendListResult,const int32,ErrorCode,const FString&,ErrorMsg, const TArray<FCsdkFriendDelResult>&, DelResults);

/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkOperateFriendList : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 批量删除好友
	 * @param WorldContextObject 
	 * @param UserIds 用户Id数组
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Relationship|Friend")
	static UCsdkOperateFriendList* DeleteFriendMulti(UObject* WorldContextObject, const TArray<FCsdkUserId>& UserIds);
	
	UPROPERTY(BlueprintAssignable)
	FCsdkOperateFriendListResult Completed;

};
