﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "UObject/Object.h"
#include "User/Data/CsdkUser.h"
#include "CsdkFriend.generated.h"


/**
 * 
 */
USTRUCT(BlueprintType)
struct FCsdkFriendInfo
{
	GENERATED_BODY()

	UPROPERTY(EditAnywhere,BlueprintReadOnly,Category= "Csdk|Relationship|Friend")
	FDateTime BeFriendTime;
	UPROPERTY(EditAnywhere,BlueprintReadOnly,Category= "Csdk|Relationship|Friend")
	TMap<FString,FString> Extra;
	
};


USTRUCT(BlueprintType)
struct CSDKRUNTIME_API FCsdkFriend
{
	GENERATED_BODY()
	UPROPERTY(EditAnywhere,BlueprintReadOnly,Category= "Csdk|Relationship|Friend")
	FCsdkUser User;
	UPROPERTY(EditAnywhere,BlueprintReadOnly,Category= "Csdk|Relationship|Friend")
	FCsdkFriendInfo FriendInfo;
};
