// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "Session/Data/CsdkSessionId.h"
#include "CsdkDeleteSession.generated.h"


DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FCsdkDeleteSessionResult, const int32, ErrorCode, const FString&, ErrorMsg);

/**#
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkDeleteSession : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 删除会话
	 * @param WorldContextObject 上下文
	 * @param UniqueId 会话Id
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Session")
	static UCsdkDeleteSession* DeleteSession(UObject* WorldContextObject,const FCsdkSessionId& UniqueId);
	
	virtual void Activate() override;
	
	/**
	 * @brief 回调
	 */
	UPROPERTY(BlueprintAssignable)
	FCsdkDeleteSessionResult Completed;
	
private:
	FCsdkSessionId SessionId;
};


