﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "Session/Data/CsdkSession.h"
#include "CsdkGetSessionList.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_ThreeParams(FCsdkGetSessionListResult, const int32, ErrorCode, const FString&, ErrorMsg,
                                               const TArray<UCsdkSession*>&, SessionList);

UCLASS()
class CSDKRUNTIME_API UCsdkGetSessionList : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 获取会话列表
	 * @param WorldContextObject 上下文环境
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|Session")
	static UCsdkGetSessionList* GetSessionList(UObject* WorldContextObject);

	virtual void Activate() override;

	UPROPERTY(BlueprintAssignable)
	FCsdkGetSessionListResult Completed;

};
