// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "ChatRoom/Data/CsdkChatRoomId.h"
#include "Data/CsdkSession.h"
#include "Data/CsdkSessionId.h"
#include "Kismet/BlueprintFunctionLibrary.h"
#include "CsdkSessionLibrary.generated.h"

/**
 * 
 */
UCLASS()
class CSDKRUNTIME_API UCsdkSessionLibrary : public UBlueprintFunctionLibrary 
{
	GENERATED_BODY()
public:
	UFUNCTION(BlueprintPure, meta=(DisplayName = "Equal CsdkSessionId", CompactNodeTitle = "==", Keywords = "== equal"), Category="CSDK|SessionId")
	static bool Equal_FCsdkSessionId(const FCsdkSessionId& A,const FCsdkSessionId& B)
	{
		return A == B;
	}

	UFUNCTION(BlueprintPure, Category="CSDK|SessionId")
	static bool IsValid(const FCsdkSessionId& A)
	{
		return A.IsValid();
	}

	UFUNCTION(BlueprintPure, Category = "CSDK|Session", meta = (DisplayName = "ToString(SessionId)", CompactNodeTitle = "->", BlueprintAutocast))
	static  FString Conv_SessionIdToString( const FCsdkSessionId& SessionId);
	
	/** Converts a ChatRoomId To SessionId */
	UFUNCTION(BlueprintPure, Category = "CSDK|Session", meta = (DisplayName = "ToSessionId(ChatRoomId)", CompactNodeTitle = "->", BlueprintAutocast))
	static  FCsdkSessionId Conv_RoomIdToSessionId( const FCsdkChatRoomId& RoomId);
	UFUNCTION(BlueprintPure, Category = "CSDK|Session", meta = (DisplayName = "ToSessionId(UserId)", CompactNodeTitle = "->", BlueprintAutocast))
	static  FCsdkSessionId Conv_UserIdToSessionId( const FCsdkUserId& UserId);
	/**
	 * @brief SDK 提供创建的接口，如果已经存在该会话，即返回此会话
	 * @param SessionId 会话唯一ID
	 * @return 会话对象
	 */
	UFUNCTION(BlueprintCallable, Category = "CSDK|Session")
	static UCsdkSession* CreateSession(const FCsdkSessionId& SessionId);
	/**
	 * @brief 查找会话
	 * @param SessionId 会话唯一ID
	 * @return 会话对象，找不到此会话则为空
	 */
	UFUNCTION(BlueprintCallable, Category = "CSDK|Session")
	static UCsdkSession* FindSession(const FCsdkSessionId& SessionId);

	/**
	 * @brief 获取会话未读数
	 * @param SessionId 会话ID
	 * @return 会话未读数
	 */
	UFUNCTION(BlueprintCallable, Category = "CSDK|Session")
	static int32 GetUnreadCount(const FCsdkSessionId& SessionId);
	/**
	 * @brief 获取所有会话未读数
	 * @return 总会话未读数
	 */
	UFUNCTION(BlueprintCallable, Category = "CSDK|Session")
	static int32 GetAllUnreadCount();
	/**
	 * @brief 清除指定会话未读数
	 * @param SessionId 会话ID
	 */
	UFUNCTION(BlueprintCallable, Category = "CSDK|Session")
	static void ClearUnreadCount(const FCsdkSessionId& SessionId);
};
