// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Engine/DeveloperSettings.h"
#include "CsdkLogSettings.generated.h"

/**
 * 
 */
UCLASS(config = CsdkSettings, defaultconfig)
class CSDKRUNTIME_API UCsdkLogSettings : public UDeveloperSettings
{
	GENERATED_BODY()
public:
	virtual FName GetContainerName() const override
	{
		return "Project";
	}

	virtual FName GetCategoryName() const override
	{
		return "CSDK";
	}
#if WITH_EDITOR	
	virtual FText GetSectionText() const override
	{
		return FText::FromString(TEXT("Log"));
	}
	
	virtual FText GetSectionDescription() const override
	{
		return FText::FromString(TEXT("英雄互娱聊天SDK设置面板"));
	}
#endif
	static UCsdkLogSettings* Get()
	{
		return GetMutableDefault<UCsdkLogSettings>();
	}
	
	UPROPERTY(Config,EditAnywhere, Category = Log)
	bool bUseCsdkLog = true;
	UPROPERTY(Config,EditAnywhere, Category = Log)
	bool bUseUeLog = true;
};
