﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "User/Data/CsdkUserControl.h"
#include "CsdkGetUserControl.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_ThreeParams(FCsdkGetUserControlResult,const int32, ErrorCode, const FString&, ErrorMsg, const FCsdkUserControl&, CsdkUserControl);

UCLASS()
class CSDKRUNTIME_API UCsdkGetUserControl : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|User")
	static UCsdkGetUserControl* GetUserControl(UObject* WorldContextObject);
	virtual void Activate() override;

	UPROPERTY(BlueprintAssignable)
	FCsdkGetUserControlResult Completed;

};


