﻿#pragma once
#include "Data/CsdkUserStatus.h"
#include "CoreMinimal.h"
#include "Data/CsdkUserId.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "CsdkGetUserListStatus.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_ThreeParams(FCsdkGetUserListStatusResult, const int32, ErrorCode, const FString&, ErrorMsg,
											   const TArray<FCsdkUserStatusResult>&, StatusResultList);

UCLASS()
class CSDKRUNTIME_API UCsdkGetUserListStatus : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"),
		Category = "CSDK|User")
	static UCsdkGetUserListStatus* GetUserListStatus(UObject* WorldContextObject,const TArray<FCsdkUserId>& UserIds);

	virtual void Activate() override;

	UPROPERTY(BlueprintAssignable)
	FCsdkGetUserListStatusResult Completed;

private:
	TArray<FCsdkUserId> UserIds;
};
