﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Data/CsdkUser.h"
#include "Kismet/BlueprintAsyncActionBase.h"
#include "CsdkUpdateUser.generated.h"

DECLARE_DYNAMIC_MULTICAST_DELEGATE_TwoParams(FCsdkUpdateUserResult, const int32, ErrorCode, const FString&, ErrorMsg);

UCLASS()
class CSDKRUNTIME_API UCsdkUpdateUser : public UBlueprintAsyncActionBase
{
	GENERATED_BODY()
public:
	/**
	 * @brief 
	 * @param WorldContextObject 
	 * @param RoleName 角色名
	 * @param Gender 性别
	 * @param AvatarUrl 头像
	 * @param Extra 扩展字段
	 * @return 
	 */
	UFUNCTION(BlueprintCallable, meta = (BlueprintInternalUseOnly = "true", WorldContext="WorldContextObject"), Category = "CSDK|User")
	static UCsdkUpdateUser* UpdateUser(UObject* WorldContextObject, const FString& RoleName,const ECsdkGender& Gender,const FString& AvatarUrl,const TMap<FString,FString>&  Extra);
	virtual void Activate() override;

	UPROPERTY(BlueprintAssignable)
	FCsdkUpdateUserResult Completed;

private:
	FString RoleName;
	ECsdkGender Gender;
	FString AvatarUrl;
	TMap<FString, FString> Extra;
};


