// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "JsonObjectConverter.h"
#include "CsdkUserId.h"
#include "Common/CsdkGender.h"
#include "CsdkUser.generated.h"



USTRUCT(BlueprintType)
struct FCsdkUser
{
	GENERATED_BODY()
	
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|User")
	FCsdkUserId Id;
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|User")
	FString RoleName;
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|User")
	ECsdkGender  Gender = ECsdkGender::Unknown ;
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|User")
	FString AvatarUrl;
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|User")
	int64 Version = 0;
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|User")
	TMap<FString,FString>  Extra;


	FString ToString() const
	{
		FString Result;
		FJsonObjectConverter::UStructToJsonObjectString(*this,Result);
		return Result;
	}

	bool IsValid() const
	{
		return Id.IsValid();
	}
};
