﻿#pragma once

#include "CoreMinimal.h"
#include "CsdkUserControl.generated.h"

USTRUCT(BlueprintType)
struct FCsdkUserControlDetail
{
	GENERATED_BODY()

	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|UserControl")
	FDateTime EndTime;
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|UserControl")
	FString Reason;
};

USTRUCT(BlueprintType)
struct FCsdkUserControl
{
	GENERATED_BODY()

	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|UserControl")
	bool bCanSendMsg = false;

	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|UserControl")
	FCsdkUserControlDetail MessageControlDetail;
	
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|UserControl")
	bool bCanSendVoice = false;
	
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|UserControl")
	FCsdkUserControlDetail VoiceControlDetail;
};

