﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "CsdkUserId.generated.h"

USTRUCT(BlueprintType)
struct FCsdkUserId
{
	GENERATED_BODY()
	
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|User")
	FString RoleId;
	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category="CSDK|User")
	FString ServerId;
	
	bool operator==(const FCsdkUserId& Other) const
	{
		return this->RoleId==Other.RoleId && this->ServerId ==Other.ServerId ;
	}

	bool operator!=(const FCsdkUserId& Other) const
	{
		return this->RoleId!=Other.RoleId || this->ServerId !=Other.ServerId ;
	}


	bool IsValid() const
	{
		return !RoleId.IsEmpty() && !ServerId.IsEmpty();
	}

	FString ToString() const
	{
		return ServerId.IsEmpty() ? RoleId: RoleId+TEXT("_")+ServerId;
	}

};

FORCEINLINE uint32 GetTypeHash(const FCsdkUserId& S)
{
	const auto Str = S.RoleId+TEXT("_")+S.ServerId;
	return FCrc::Strihash_DEPRECATED(Str.Len(), *Str);
}


