// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "JsonObjectConverter.h"
#include "CsdkUserId.h"
#include "CsdkUserOperateResult.generated.h"



USTRUCT(BlueprintType)
struct FCsdkUserOperateResult
{
	GENERATED_BODY()
	
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|User")
	FCsdkUserId Id;
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|User")
	FString Msg;
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|User")
	int32 ErrorCode = 0;


	FString ToString() const
	{
		FString Result;
		FJsonObjectConverter::UStructToJsonObjectString(*this,Result);
		return Result;
	}
};
