﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "CsdkUserSearch.generated.h"

UENUM(BlueprintType)
enum class ECsdkUserSearchOperator : uint8
{
	None,
	Equal,
	NotEqual,
	Contain,
	NotContian
};



USTRUCT(BlueprintType)
struct FCsdkUserSearchCondition
{
	GENERATED_BODY()
	
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|User|Search")
	FString Field;
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|User|Search")
	ECsdkUserSearchOperator Operator = ECsdkUserSearchOperator::None;
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|User|Search")
	FString Value;
};



