﻿// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "CsdkUserId.h"
#include "CsdkUserStatus.generated.h"

USTRUCT(BlueprintType)
struct FCsdkUserStatus
{
	GENERATED_BODY()
	
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|User")
	bool bIsOnline = false;
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|User")
	FDateTime LastOnlineTime;
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|User")
	TMap<FString,FString>  Extra;
};

USTRUCT(BlueprintType)
struct FCsdkUserStatusResult
{
	GENERATED_BODY()
	
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|User")
	FCsdkUserId UserId;
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|User")
	int32 ErrorCode = 0;
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|User")
	FCsdkUserStatus UserStatus;
	UPROPERTY(BlueprintReadOnly, EditAnywhere, Category="CSDK|User")
	FString  Msg;
};

