// Copyright 1998-2017 Epic Games, Inc. All Rights Reserved.

using UnrealBuildTool;
using System;
using System.IO;

public class GMESDK : ModuleRules
{
#if WITH_FORWARDED_MODULE_RULES_CTOR
    public GMESDK(ReadOnlyTargetRules Target) : base(Target)
#else
    public GMESDK(TargetInfo Target)
#endif
    {
        string GMELibPath = string.Empty;
        string PluginPath = ModuleDirectory;
        System.Console.WriteLine("-------------- PluginPath = " + PluginPath);
        string GMEThirdPartyDir = Path.GetFullPath(Path.Combine(ModuleDirectory, "../ThirdParty/GMESDKLibrary"));
        System.Console.WriteLine("-------------- GMEThirdPartyDir = " + GMEThirdPartyDir);
        System.Console.WriteLine("-------------- GMEBuildTarget = " + Target.Platform);
        
        PrivatePCHHeaderFile = "Private/GMEAppDelegate.h";
        PublicIncludePaths.AddRange(
            new string[] {
                Path.Combine(PluginPath, "Public"),
                Path.Combine(PluginPath, "Public/GMESDK"),
                // ... add public include paths required here ...
            }
            );
        
        PrivateIncludePaths.AddRange(
            new string[] {
                Path.Combine(PluginPath, "Private"),
                // ... add other private include paths required here ...
            }
            );
            
        
        PublicDependencyModuleNames.AddRange(
            new string[]
            {
                "Core",
                "Projects",
                "GMESDKLibrary"
                // ... add other public dependencies that you statically link with here ...
            }
            );
            
        
        PrivateDependencyModuleNames.AddRange(
            new string[]
            {
                // ... add private dependencies that you statically link with here ...    
            }
            );        
        DynamicallyLoadedModuleNames.AddRange(
            new string[]
            {
                // ... add any modules that your module loads dynamically here ...
            }
            );

        if (Target.Platform == UnrealTargetPlatform.Android)
        {
            PrivateDependencyModuleNames.AddRange(new string[] { "Launch" });

            string uplPath = Path.Combine(PluginPath, "GMESDK_APL.xml");
            System.Console.WriteLine("-------------- Android UPL file path:" + uplPath);
            AdditionalPropertiesForReceipt.Add("AndroidPlugin", uplPath);
        }
        else if (Target.Platform.ToString() == "OpenHarmony")
        {
            string uplPath = Path.Combine(PluginPath, "GMESDK_UPL_OpenHarmony.xml");
            System.Console.WriteLine("-------------- OHOS UPL file path:" + uplPath);
            AdditionalPropertiesForReceipt.Add("OpenHarmonyPlugin", uplPath);
        }
        else if (Target.Platform == UnrealTargetPlatform.IOS )
        {
            PrivateIncludePaths.Add("GMESDK/Private/iOS");
            PublicIncludePaths.AddRange(new string[] {"Runtime/ApplicationCore/Public/Apple", "Runtime/ApplicationCore/Public/IOS"});

            PrivateDependencyModuleNames.AddRange(
                new string[]
                {
                    "ApplicationCore"
                    // ... add private dependencies that you statically link with here ...
                }
                );
        }

        if (Target.Platform == UnrealTargetPlatform.Win64)
        {
            string OSVersion = "x64";
            string libDir = OSVersion;
            GMELibPath = Path.Combine(GMEThirdPartyDir, libDir);
            Console.WriteLine("GMELibPath:" + GMELibPath);
            string libFilePath = Path.Combine(GMELibPath, "GMESDK.lib");
            Console.WriteLine("GMELibFilePath:" + GMELibPath);
            PublicAdditionalLibraries.Add(libFilePath);

            string binariesDir = Path.Combine(ModuleDirectory, "../../Binaries", Target.Platform.ToString());
            if (!Directory.Exists(binariesDir))
                Directory.CreateDirectory(binariesDir);

            string[] dllNames = new string[] {
                    "GMESDK.dll",
                    "txffmpeg.dll",
                    "txsoundtouch.dll"
                };

            foreach (string dllName in dllNames)
            {
                RuntimeDependencies.Add("$(TargetOutputDir)/"+ dllName, Path.Combine(GMELibPath, dllName));
            }

            try
            {
                foreach (string dllName in dllNames)
                {
                    System.Console.WriteLine("src dll=" + dllName + " dst dir=" + binariesDir);
                    File.Copy(Path.Combine(GMELibPath, dllName), Path.Combine(binariesDir, dllName), true);
                }
            }
            catch (Exception e)
            {
                System.Console.WriteLine("copy dll exception,maybe have exists,err=", e.ToString());
            }
        }
#if UE_5_0_OR_LATER
#else
        else if (Target.Platform == UnrealTargetPlatform.Win32)
        {
            string OSVersion = "x86";
            string libDir = OSVersion;
            GMELibPath = Path.Combine(GMEThirdPartyDir, libDir);
            Console.WriteLine("GMELibPath:" + GMELibPath);
            string libFilePath = Path.Combine(GMELibPath, "GMESDK.lib");
            Console.WriteLine("GMELibFilePath:" + GMELibPath);
            PublicAdditionalLibraries.Add(libFilePath);

            string binariesDir = Path.Combine(ModuleDirectory, "../../Binaries", Target.Platform.ToString());
            if (!Directory.Exists(binariesDir))
                Directory.CreateDirectory(binariesDir);

            string[] dllNames = new string[] {
                    "GMESDK.dll"
                };

            foreach (string dllName in dllNames)
            {
               RuntimeDependencies.Add("$(TargetOutputDir)/" + dllName, Path.Combine(GMELibPath, dllName));
            }

            try
            {
                foreach (string dllName in dllNames)
                {
                    System.Console.WriteLine("src dll=" + dllName + " dst dir=" + binariesDir);
                    File.Copy(Path.Combine(GMELibPath, dllName), Path.Combine(binariesDir, dllName), true);
                }
            }
            catch (Exception e)
            {
                System.Console.WriteLine("copy dll exception,maybe have exists,err=", e.ToString());
            }
        }
#endif
        else if (Target.Platform == UnrealTargetPlatform.Android)
        {
            string libDir = ("Android/GME/libs");
            string[] archs = new string[] 
            {
                "armeabi-v7a",
                "arm64-v8a",
                "x86_64",
                "x86"
            };
            foreach (var arch in archs)
            {
                GMELibPath = Path.Combine(Path.Combine(GMEThirdPartyDir, libDir), arch);
                System.Console.WriteLine("--------------Android GME Lib path = " + GMELibPath);
                PublicAdditionalLibraries.Add(Path.Combine(GMELibPath, "libgmesdk.so"));
            }
        }
        else if (Target.Platform.ToString() == "OpenHarmony")
        {
            string libDir = ("OpenHarmony/libs");
            string[] archs = new string[] 
            {
                "arm64-v8a",
                "x86_64"
            };
            string[] nativeLibs = new string[] 
            {
                "libgmesdk.so",
                "libtxffmpeg.so",
                "libtxsoundtouch.so"
            };
            foreach (var arch in archs)
            {
                GMELibPath = Path.Combine(Path.Combine(GMEThirdPartyDir, libDir), arch);
                System.Console.WriteLine("--------------OpenHarmony GME Lib path = " + GMELibPath);
                foreach (var lib in nativeLibs) {
                    System.Console.WriteLine("--------------OpenHarmony GME Lib file path = " + Path.Combine(GMELibPath, lib));
                    PublicAdditionalLibraries.Add(Path.Combine(GMELibPath, lib));
                }
            }
        }
        else if (Target.Platform == UnrealTargetPlatform.Mac)
        {
            GMELibPath = GMEThirdPartyDir;
            PublicAdditionalLibraries.AddRange(
                new string[] {
                    "c++",
                    "z",
                    "iconv",
                    "resolv",
                }
            );

            PublicFrameworks.AddRange(
                new string[] {
                    "Foundation",
                    "AVFoundation",
                    "CoreTelephony",
                    "Security",
                    "SystemConfiguration",
                    "AudioToolbox",
                    "CoreMedia",
                    "CoreAudio",
                    "CoreVideo",
                    "OpenAL",
                    GMELibPath + "/Mac/GMESDK.framework",
                    GMELibPath + "/Mac/TXFFmpeg.framework",
                    GMELibPath + "/Mac/TXSoundTouch.framework",
                }
            );

            string strGMESDKLib = GMELibPath + "/Mac/GMESDK.framework/GMESDK";
            string strFFmpegLib = GMELibPath + "/Mac/TXFFmpeg.framework/TXFFmpeg";
            string strSoundTouchLib = GMELibPath + "/Mac/TXSoundTouch.framework/TXSoundTouch";
            RuntimeDependencies.Add(strGMESDKLib);
            RuntimeDependencies.Add(strFFmpegLib);
            RuntimeDependencies.Add(strSoundTouchLib);
        }
        else if (Target.Platform == UnrealTargetPlatform.IOS)
        {
            GMELibPath = GMEThirdPartyDir;
            PublicAdditionalLibraries.AddRange(
                new string[] {
                    "c++",
                    "c++.1",
                    "z",
                    "iconv",
                    "resolv",
                }
            );

            PublicFrameworks.AddRange(
                new string[] {
                    "Foundation",
                    "AVFoundation",
                    "CoreTelephony",
                    "Security",
                    "SystemConfiguration",
                    "AudioToolbox",
                    "CoreMedia",
                    "CoreAudio",
                    "CoreVideo",
                    "OpenAL",
                    "CFNetwork",
                    "CoreServices",
                    "Accelerate"
                }
            );            
            
            string[] embedLibs = new string[] 
            {
                "GMESDK",
                "TXFFmpeg",
                "TXSoundTouch"
            };

            foreach (var lib in embedLibs)
            {
                string frameworkLib = lib + ".framework";
                System.Console.WriteLine("---framework path:" + frameworkLib);

                if (!Directory.Exists(Path.Combine(GMELibPath, "iOS", frameworkLib)))
                {
                    continue;
                }
                PublicAdditionalLibraries.Add(Path.Combine(GMELibPath, "iOS", frameworkLib, lib));
                RuntimeDependencies.Add(Path.Combine(GMELibPath,  "iOS", frameworkLib, "Info.plist"), UnrealBuildTool.StagedFileType.SystemNonUFS);
                RuntimeDependencies.Add(Path.Combine(GMELibPath,  "iOS", frameworkLib, lib), UnrealBuildTool.StagedFileType.SystemNonUFS);
            }
        }
        else
        {
            Console.WriteLine("GMESDK.build.cs Unsupported Platform by now!!!!!!!!!!!!!!!!!!!!!!!!!!!!! Target = " + Target.Platform);
        }
    }
}

