import window from '@ohos.window';
let storage = new LocalStorage();
storage.setOrCreate('dashboardIDList', []);
storage.setOrCreate('dashboardStatusList', {});
storage.setOrCreate('dashboardLogList', {});
class DashBoardView extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        this.__dashboardIDList = this.createLocalStorageLink('dashboardIDList', [], "dashboardIDList");
        this.__dashboardStatusList = this.createLocalStorageLink('dashboardStatusList', {}, "dashboardStatusList");
        this.__dashboardLogList = this.createLocalStorageLink('dashboardLogList', {}, "dashboardLogList");
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.__selectedIDIndex = new ObservedPropertySimplePU(-1, this, "selectedIDIndex");
        this.logScroller = new Scroller();
        this.setInitiallyProvidedValue(params);
    }
    setInitiallyProvidedValue(params) {
        if (params.selectedIDIndex !== undefined) {
            this.selectedIDIndex = params.selectedIDIndex;
        }
        if (params.logScroller !== undefined) {
            this.logScroller = params.logScroller;
        }
    }
    updateStateVars(params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__dashboardIDList.purgeDependencyOnElmtId(rmElmtId);
        this.__dashboardStatusList.purgeDependencyOnElmtId(rmElmtId);
        this.__dashboardLogList.purgeDependencyOnElmtId(rmElmtId);
        this.__selectedIDIndex.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__dashboardIDList.aboutToBeDeleted();
        this.__dashboardStatusList.aboutToBeDeleted();
        this.__dashboardLogList.aboutToBeDeleted();
        this.__selectedIDIndex.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    aboutToAppear() { }
    aboutToDisappear() { }
    get dashboardIDList() {
        return this.__dashboardIDList.get();
    }
    set dashboardIDList(newValue) {
        this.__dashboardIDList.set(newValue);
    }
    get dashboardStatusList() {
        return this.__dashboardStatusList.get();
    }
    set dashboardStatusList(newValue) {
        this.__dashboardStatusList.set(newValue);
    }
    get dashboardLogList() {
        return this.__dashboardLogList.get();
    }
    set dashboardLogList(newValue) {
        this.__dashboardLogList.set(newValue);
    }
    get selectedIDIndex() {
        return this.__selectedIDIndex.get();
    }
    set selectedIDIndex(newValue) {
        this.__selectedIDIndex.set(newValue);
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Flex.create({ direction: FlexDirection.Column, wrap: FlexWrap.NoWrap });
            Flex.width('100%');
            Flex.padding(30);
            Flex.backgroundColor(Color.Gray);
        }, Flex);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.width('100%');
            Row.flexBasis('auto');
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create("Dashboard");
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Blank.create();
        }, Blank);
        Blank.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel('Close');
            Button.onClick(() => {
                let windowClass = window.findWindow("liteav_dashboard_window");
                windowClass.destroyWindow();
            });
        }, Button);
        Button.pop();
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.width('100%');
            Row.flexBasis('auto');
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Select.create(this.dashboardIDList.map((i) => { return { value: i }; }));
            Select.selected(Math.min(this.dashboardIDList.length - 1, Math.max(0, (this.selectedIDIndex))));
            Select.value(this.dashboardIDList[Math.min(this.dashboardIDList.length - 1, Math.max(0, (this.selectedIDIndex)))]);
            Select.onSelect((index, text) => {
                this.selectedIDIndex = index;
            });
            Select.width('100%');
        }, Select);
        Select.pop();
        Row.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(this.dashboardStatusList[this.dashboardIDList[Math.min(this.dashboardIDList.length - 1, Math.max(0, (this.selectedIDIndex)))]]);
            Text.fontSize(12);
            Text.align(Alignment.TopStart);
            Text.width('100%');
            Text.padding(5);
            Text.width('100%');
            Text.height('25%');
            Text.flexGrow(1);
            Text.border({ width: 1, color: Color.Black, style: BorderStyle.Solid });
        }, Text);
        Text.pop();
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Scroll.create(this.logScroller);
            Scroll.width('100%');
            Scroll.height('50%');
            Scroll.flexGrow(2);
            Scroll.border({ width: 1, color: Color.Black, style: BorderStyle.Solid });
        }, Scroll);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Text.create(this.dashboardLogList[this.dashboardIDList[Math.min(this.dashboardIDList.length - 1, Math.max(0, (this.selectedIDIndex)))]]);
            Text.fontSize(12);
            Text.align(Alignment.TopStart);
            Text.width('100%');
            Text.padding(5);
        }, Text);
        Text.pop();
        Scroll.pop();
        Flex.pop();
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName() {
        return "DashBoardView";
    }
}
export class LiteavDashboardApp {
    constructor() {
        this.windowClass = undefined;
    }
    nativeShowDashboard() {
        let config = {
            name: "liteav_dashboard_window",
            windowType: window.WindowType.TYPE_DIALOG,
            ctx: globalThis.getContext()
        };
        window.createWindow(config, (err, data) => {
            var _a;
            if (err.code) {
                console.error('Failed to create the Window. Cause:' + JSON.stringify(err));
                return;
            }
            this.windowClass = data;
            console.info('Succeeded in creating the window. Data:' + JSON.stringify(data));
            (_a = this.windowClass) === null || _a === void 0 ? void 0 : _a.loadContentByName('liteav_dashboard_view', (err) => {
                var _a;
                if (err.code) {
                    console.error('Failed to load the content. Cause: ' + JSON.stringify(err));
                    return;
                }
                console.info('Succeeded in loading the content.');
                (_a = this.windowClass) === null || _a === void 0 ? void 0 : _a.showWindow((err) => {
                    if (err.code) {
                        console.error('Failed to show the window. Cause: ' + JSON.stringify(err));
                        return;
                    }
                    console.info('Succeeded in showing the window.');
                });
            });
        });
    }
    nativeHideDashboard() {
        var _a;
        (_a = this.windowClass) === null || _a === void 0 ? void 0 : _a.destroyWindow((err) => {
            if (err.code) {
                console.error('Failed to destroy the window. Cause:' + JSON.stringify(err));
                return;
            }
            console.info('Succeeded in destroying the window.');
        });
    }
    nativeAddDashboard(dashboardID) {
        let dashboardIDList = storage.get('dashboardIDList');
        const index = dashboardIDList.findIndex(item => item === dashboardID);
        if (index !== -1) {
            return;
        }
        dashboardIDList.push(dashboardID);
    }
    nativeRemoveDashboard(dashboardID) {
        let dashboardIDList = storage.get('dashboardIDList');
        const index = dashboardIDList.findIndex(item => item === dashboardID);
        if (index === -1) {
            return;
        }
        dashboardIDList.splice(index, 1);
        let dashboardStatusList = storage.get('dashboardStatusList');
        dashboardStatusList[dashboardID] = "";
        let dashboardLogList = storage.get('dashboardLogList');
        dashboardLogList[dashboardID] = "";
    }
    nativeRemoveAllDashboard() {
        storage.setOrCreate('dashboardIDList', []);
        storage.setOrCreate('dashboardStatusList', {});
        storage.setOrCreate('dashboardLogList', {});
    }
    nativeSetStatus(dashboardID, status) {
        let dashboardIDList = storage.get('dashboardIDList');
        const index = dashboardIDList.findIndex(item => item === dashboardID);
        if (index === -1) {
            return;
        }
        let dashboardStatusList = storage.get('dashboardStatusList');
        dashboardStatusList[dashboardID] = status;
    }
    nativeAppendLog(dashboardID, log) {
        let dashboardIDList = storage.get('dashboardIDList');
        const index = dashboardIDList.findIndex(item => item === dashboardID);
        if (index === -1) {
            return;
        }
        let dashboardLogList = storage.get('dashboardLogList');
        let logOld = dashboardLogList[dashboardID];
        if (typeof logOld === 'string') {
            dashboardLogList[dashboardID] = logOld + "\n" + log;
        }
        else {
            dashboardLogList[dashboardID] = log;
        }
    }
}
{
    let routeNameNode = 'liteav_dashboard_view';
    if (routeNameNode != undefined) {
        registerNamedRoute(() => new DashBoardView(undefined, {}, storage), routeNameNode, { bundleName: "com.liteav.demo", moduleName: "liteavsdk", pagePath: "" });
    }
    else {
        registerNamedRoute(() => new DashBoardView(undefined, {}, storage), "", { bundleName: "com.liteav.demo", moduleName: "liteavsdk", pagePath: "" });
    }
}
//# sourceMappingURL=liteav_dashboard_app.js.map