// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Voice/CsdkVoiceBase.h"
#include "GMESDK/tmg_sdk.h"
#include "GMEObject.generated.h"

/**
 * 
 */
UCLASS(BlueprintType)
class GMESUPPORT_API UGMEObject : public UCsdkVoiceBase, public ITMGDelegate
{
	GENERATED_BODY()
public:
	
	//初始化&&反初始化
	virtual bool Init(UCsdkVoiceSupportSubsystem* CsdkVoiceSupportSubsystem) override;
	virtual int32 UnInit() override;

	//暂停语音功能&&恢复语音功能
	virtual int32 Pause() override;
	virtual int32 Resume() override;
	


	//开始录音&&停止录音
	virtual int32 StartRecording(const FRecordFileCompleted& InRecordFileCompleted) override;
	virtual int32 StopRecordingRaw() override;
	virtual int32 StopRecording() override;
	virtual int32 CancelRecording() override;

	//语音文件上传&&下载
	virtual int32 UploadRecordedFile(const FString& FilePath, const FUploadRecordedFileCompleted& InOnUploadRecordedFileCompleted) override;
	virtual int32 DownloadRecordedFile(const FString& FileId, FDownloadRecordedFileCompleted InOnDownloadRecordedFileCompleted) override;

	//播放语音&&停止播放语音
	virtual int32 PlayRecordedFile(const FString& FilePath,const FPlayRecordedFileCompleted& PlayRecordedFileCompleted) override;
	virtual int32 StopPlayFile() override;
	//获取语音文件大小&&时长
	virtual int32 GetFileSize(const FString& FilePath) override;
	virtual float GetVoiceFileDuration(const FString& FilePath) override;

	// 翻译自己的语音消息（离线语音转文字模式）
	virtual int32 SpeechToText(const FString& FileId,const FSpeechToTextCompleted& SpeechToTextCompleted) override;

	//流式语音转文本
	virtual int32 StartStreamSpeechToText(const FStreamSpeechToTextRunning& InStreamSpeechToTextRunning,
		const FStreamSpeechToTextCompleted& StreamSpeechToTextCompleted) override;
	virtual int32 StopStreamSpeechToText() override;

	//进入房间
	virtual int32 EnterVoiceRoom(const FString& RoomId, const FEnterRoomCompleted& EnterRoomCompleted) override;
	virtual int32 ExitVoiceRoom(const FExitRoomCompleted& ExitRoomCompleted) override;

	virtual int32 SWitchVoiceRoom(const FString& RoomId, const FSwitchRoomCompleted& SwitchRoomCompleted) override;

	virtual TArray<FString> GetVoiceRoomMemberOpenIds() const override;
	
	virtual int32 OpenMic() override;
	virtual int32 CloseMic() override;
	virtual int32 OpenSpeaker() override;
	virtual int32 CloseSpeaker() override;
	
	virtual void OnEvent(ITMG_MAIN_EVENT_TYPE eventType, const char *data) override;
private:
	bool Tick(float DeltaTime);
	virtual FString GetRecordingFileName() override;
	virtual FString GetDownloadFilePath() override;
	void OnRecordingCompletedEvent(const TSharedPtr<FJsonObject>& JsonObject);
	void OnUploadRecordedFileCompletedEvent(const TSharedPtr<FJsonObject>& JsonObject);
	void OnDownloadRecordedFileCompletedEvent(const TSharedPtr<FJsonObject>& JsonObject);
	void OnPlayRecordedFileCompletedEvent(const TSharedPtr<FJsonObject>& JsonObject);
	void OnSpeechToTextCompletedEvent(const TSharedPtr<FJsonObject>& JsonObject) ;
	void OnStreamSpeechToTextCompletedEvent(const TSharedPtr<FJsonObject>& JsonObject);
	void OnStreamSpeechToTextRunningEvent(const TSharedPtr<FJsonObject>& JsonObject);
	void OnEnterVoiceRoom(const TSharedPtr<FJsonObject>& JsonObject);
	void OnExitVoiceRoom(const TSharedPtr<FJsonObject>& JsonObject);
	void OnVoiceRoomDisconnect(const TSharedPtr<FJsonObject>& JsonObject);
	void OnVoiceRoomReconnectStart(const TSharedPtr<FJsonObject>& JsonObject);
	void OnVoiceRoomReconnectSuccess(const TSharedPtr<FJsonObject>& JsonObject);
	void OnVoiceRoomUserUpdate(const TSharedPtr<FJsonObject>& JsonObject);
	void OnUserEnterVoiceRoom(const TArray<FString>& NewMembers);
	void OnUserExitVoiceRoom(const TArray<FString>& NewMembers);
private:
	TArray<FString> VoiceRoomMembers;
};


