// Copyright Epic Games, Inc. All Rights Reserved.

//#define USE_STEAM
using System;
using System.IO;
using System.Reflection;
using System.Text;
using UnrealBuildTool;
using System.Text.RegularExpressions;
using System.Diagnostics;
#if UE_5_0_OR_LATER
using EpicGames.Core;
#else
using Tools.DotNETCommon;
#endif

public class HeroUSDKPlugin : ModuleRules
{
	private bool bIsJuLiang = false;
	private bool bIsDouYin = false;
	public HeroUSDKPlugin(ReadOnlyTargetRules Target) : base(Target)
	{
	
		//LoadDefaultEngineConfig();
		PCHUsage = ModuleRules.PCHUsageMode.UseExplicitOrSharedPCHs;
		PublicIncludePaths.AddRange(
			new string[]
			{
				Path.Combine(ModuleDirectory,"Public","Log"),
				Path.Combine(ModuleDirectory,"Public","Manager"),
				Path.Combine(ModuleDirectory,"Public","Platform","PC"),
				Path.Combine(ModuleDirectory,"Public","Platform","PC","Widget"),
				
				// ... add public include paths required here ...
			}
		);
		
		if (Target.Platform.Equals(UnrealTargetPlatform.Mac) ||Target.Platform.Equals(UnrealTargetPlatform.IOS))
		{
			//DownloadImageAsync();
			Exception ex = AppendChangeAdditionalCompilerArguments
			(
				Target, 
				"-Wno-bitwise-instead-of-logical",
				"-Wno-unused-but-set-variable",
				"-Wno-unused-function",
				"-Wno-deprecated-builtins",
				"-Wno-single-bit-bitfield-constant-conversion" 
			);
			if (ex != null)
			{
				throw ex;
			}
		} 
		if (Target.Platform.Equals(UnrealTargetPlatform.IOS))
		{
			Exception ex = AppendChangeAdditionalLinkerArguments
			(
				Target,
				"-ObjC"
			);
			if (ex != null)
			{
				throw ex;
			}
		} 

		PrivateIncludePaths.AddRange(
			new string[]
			{
				Path.Combine(ModuleDirectory,"Private","Platform","PC")
				// ... add other private include paths required here ...

			}
		);
#if USE_STEAM
PublicDefinitions.Add("USE_STEAM");
PublicDependencyModuleNames.AddRange(
			new string[]
			{
				"Core",
				"Json",
				"Projects",
				"ApplicationCore",
				"JsonUtilities",
				"HTTP",
				"HTTPServer",
				"WebBrowser",
				"OnlineSubsystem",
				"OnlineSubsystemUtils",
				"Steamworks",
				"DeveloperSettings"
			}
		);

		PrivateDependencyModuleNames.AddRange(
			new string[]
			{
				"CoreUObject",
				"Engine",
				"Slate",
				"SlateCore",
				"UMG",
				"OnlineSubsystem",
				"XmlParser",
				
			}
		);

		 DynamicallyLoadedModuleNames.AddRange(
			new string[]
			{
				"OnlineSubsystemSteam"
			}
		);

#else
        PublicDependencyModuleNames.AddRange(
			new string[]
			{
				"Core",
				"Json",
				"Projects",
				"ApplicationCore",
				"JsonUtilities",
				"HTTP",
				"HTTPServer",
				"WebBrowser",
				"XmlParser",
				"HeroMarket",
				"DeveloperSettings"
			}
		);

		PrivateDependencyModuleNames.AddRange(
			new string[]
			{
				"CoreUObject",
				"Engine",
				"Slate",
				"SlateCore",
				"UMG",
				"PlatformCryptoOpenSSL",
				"Sockets",
				"InputCore", 
			}
		);

		if (Target.bBuildEditor)
		{
			PrivateDependencyModuleNames.Add("UnrealEd");
		}
#endif
		if (Target.Platform == UnrealTargetPlatform.IOS)
		{
			PublicIncludePaths.AddRange(new string[] {"Runtime/ApplicationCore/Public/IOS"});
			PrivateIncludePaths.Add(	Path.Combine(ModuleDirectory,"Private","Platform","IOS"));
		}
		else if (Target.Platform == UnrealTargetPlatform.Mac)
		{
			PublicIncludePaths.AddRange(new string[] {"Runtime/ApplicationCore/Public/Apple"});

		}

		if (Target.Platform == UnrealTargetPlatform.Win64)
		{
			string Channel = string.Empty;
			if (Target.ProjectFile != null)
			{
				string ProjectPath = Path.GetDirectoryName(Target.ProjectFile.ToString());
				var Ini = ConfigCache.ReadHierarchy(ConfigHierarchyType.Game,
					new DirectoryReference(ProjectPath), Target.Platform);

				Ini.TryGetValue("/Script/HeroUSDKPlugin.UsdkSettings", "Channel", out Channel);

			}
			
			PublicDefinitions.Add("USE_TAPTAP=1");
			PublicDependencyModuleNames.AddRange(new string[] { 
				"TapCommon",
				"TapLogin"
			});

			if (Channel == "Bilibili")
			{
				RuntimeDependencies.Add("$(PluginDir)/Source/HeroUSDKPlugin/Windows/Bili/**");
			}
			else if (Channel == "WeGame")
			{
				PublicDefinitions.Add("USE_WEGAME=1");
				
				string includeDir = Path.Combine(ModuleDirectory, "Windows/WeGame");
				Console.WriteLine("includeDir"+includeDir);
				PublicIncludePaths.Add(includeDir);
				
				string libraryDirectory = Path.Combine(ModuleDirectory, "Windows/WeGame/rail/libs/win/Release_64");
				PublicAdditionalLibraries.Add(Path.Combine(libraryDirectory, "rail_api64.lib"));
     
				PublicDelayLoadDLLs.Add("rail_api64.dll");
				RuntimeDependencies.Add("$(BinaryOutputDir)/../ThirdParty/WeGame/Win64/rail_api64.dll", Path.Combine(libraryDirectory, "rail_api64.dll"));

				var webPath = Path.Combine(ModuleDirectory, "../../Resources/network_error.html");
				RuntimeDependencies.Add("$(ProjectDir)/Content/network_error.html", webPath);
			
				var FrontEndFiles = Path.Combine(PluginDirectory, "Resources/Web/**");
				RuntimeDependencies.Add(FrontEndFiles, StagedFileType.NonUFS);
			}
			else
			{
				PublicDependencyModuleNames.AddRange(new string[] { "Core",
					"CoreUObject",
					"Engine",
					"Json",
					"InputCore",
					"JsonUtilities",
					"SlateCore",
				});
				
				var webPath = Path.Combine(ModuleDirectory, "../../Resources/network_error.html");
				RuntimeDependencies.Add("$(ProjectDir)/Content/network_error.html", webPath);
			
				var FrontEndFiles = Path.Combine(PluginDirectory, "Resources/Web/**");
				RuntimeDependencies.Add(FrontEndFiles, StagedFileType.NonUFS);
			}
		}

		if (Target.Platform == UnrealTargetPlatform.Android)
		{
			PrivateIncludePaths.Add(	Path.Combine(ModuleDirectory,"Private","Platform","Android"));
			PrivateDependencyModuleNames.AddRange(new string[]
			{
				"Launch"
			});

			string PluginPath = Utils.MakePathRelativeTo(ModuleDirectory, Target.RelativeEnginePath);
			AdditionalPropertiesForReceipt.Add("AndroidPlugin",
				System.IO.Path.Combine(PluginPath, "HeroUSDKPlugin_APL.xml"));
		}
		else if (Target.Platform == UnrealTargetPlatform.IOS)
		{
			PublicDefinitions.Add("TargetUltra=0");
			PublicDefinitions.Add("TARGET_TV_OS=0");
			PublicDefinitions.Add("BUCK=1");
			PublicDefinitions.Add("FBSDK_SWIFT_PACKAGE=0");
			PublicDefinitions.Add("FBTEST=0");
			PublicDefinitions.Add("DEBUG=0");
			string PluginPath = Utils.MakePathRelativeTo(ModuleDirectory, Target.RelativeEnginePath);
			PublicAdditionalFrameworks.Add(
				new Framework(
					"HeroBaseSDK",
					"iOS/HeroBaseSDK.embeddedframework.zip",
					null,
					true
				)
			);
			PublicAdditionalFrameworks.Add(
				new Framework(
					"HeroUSDK",
					"iOS/HeroUSDK.embeddedframework.zip",
					null,
					true
				)
			);
			PublicAdditionalFrameworks.Add(
				new Framework(
					"HeroAnalyticsSDK",
					"iOS/HeroAnalyticsSDK.embeddedframework.zip",
					null,
					true
				)
			);

			PublicSystemLibraries.Add("xml2");

			PublicFrameworks.AddRange(
				new string[]
				{
					"Accelerate",
					"SafariServices",
					"WebKit",
					"VideoToolbox"
				}
			);

// #if UE_5_0_OR_LATER
// 			PublicAdditionalFrameworks.Add(
// 				new Framework(
// 					"swift_framework_dynamic",
// 					"swift_framework_dynamic.embeddedframework.zip",
// 					null,
// 					true
// 				)
// 			);
// #endif
			string Channel = string.Empty;
			if (Target.ProjectFile != null)
			{
				Console.WriteLine("Channel:-------->" + Channel);
				string ProjectPath = Path.GetDirectoryName(Target.ProjectFile.ToString());
				var Ini = ConfigCache.ReadHierarchy(ConfigHierarchyType.Game,
					new DirectoryReference(ProjectPath), Target.Platform);
				Console.WriteLine("ProjectPath:-------->" + ProjectPath);
				string TempBool;
				if (Ini.TryGetValue("/Script/HeroUSDKPlugin.UsdkSettings", "Channel", out TempBool))
					Channel = TempBool;
			}
			Console.WriteLine("Channel:-------->" + Channel);
			if (String.IsNullOrEmpty(Channel))
			{
				throw new Exception("Error: 错误！未配置USDK参数。 请先启动Editor，并在项目设置中的USDK配置界面配置USDK参数");
			}
			bool enableGlobal = !Channel.Equals("China");

			if (enableGlobal)
			{
				//全球渠道

				PublicAdditionalFrameworks.Add(
					new Framework(
						"HeroGlobalSDK",
						"iOS/Global/HeroGlobalSDK.embeddedframework.zip",
						null,
						true
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"FBSDKCoreKit",
						"iOS/Global/ThirdPartSDK/Facebook/FBSDKCoreKit.embeddedframework.zip"
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"FBSDKGamingServicesKit",
						"iOS/Global/ThirdPartSDK/Facebook/FBSDKGamingServicesKit.embeddedframework.zip"
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"FBSDKCoreKit_Basics",
						"iOS/Global/ThirdPartSDK/Facebook/FBSDKCoreKit_Basics.embeddedframework.zip"
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"FBSDKLoginKit",
						"iOS/Global/ThirdPartSDK/Facebook/FBSDKLoginKit.embeddedframework.zip"
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"FBAEMKit",
						"iOS/Global/ThirdPartSDK/Facebook/FBAEMKit.embeddedframework.zip"
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"FBSDKShareKit",
						"iOS/Global/ThirdPartSDK/Facebook/FBSDKShareKit.embeddedframework.zip"
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"GoogleSignIn",
						"iOS/Global/ThirdPartSDK/GoogleSDK/GoogleSignIn.embeddedframework.zip",
						"GoogleSignIn.bundle"
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"GoogleSignInDependencies",
						"iOS/Global/ThirdPartSDK/GoogleSDK/GoogleSignInDependencies.embeddedframework.zip"
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"LineSDK",
						"iOS/Global/ThirdPartSDK/LineSDK/LineSDK.embeddedframework.zip",
						"LineSDKResource.bundle"
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"TwitterKit",
						"iOS/Global/ThirdPartSDK/Twitter/TwitterKit.embeddedframework.zip",
						"TwitterKitResources.bundle"
					)
				);
				//
				// PublicAdditionalFrameworks.Add(
				// 	new Framework(
				// 		"TwitterCore",
				// 		"iOS/Global/ThirdPartSDK/Twitter/TwitterCore.embeddedframework.zip"
				// 	)
				// );


				PublicAdditionalLibraries.AddRange(
					new string[]
					{
						"c++",
						"sqlite3.0",
						"z",
					});

				PublicWeakFrameworks.AddRange(new string[]
				{
					"AuthenticationServices",
					"AppTrackingTransparency",
				});

				// These are iOS system libraries
				PublicFrameworks.AddRange(
					new string[] 
					{
						"LocalAuthentication",
						"StoreKit",
						"iAd",
						"AdSupport",
						"Accounts",
						"CoreGraphics",
						"CoreTelephony",
						"Accelerate",
						"MapKit",
						"SafariServices",
						"Security",
						"SystemConfiguration"
					});
				AdditionalPropertiesForReceipt.Add("IOSPlugin",
					System.IO.Path.Combine(PluginPath, "HeroUSDKPlugin_UPL_Global.xml"));
			}
			else
			{
				//国内渠道

				string LibWeChatDir =
					System.IO.Path.GetFullPath(System.IO.Path.Combine(ModuleDirectory,
						"../HeroUSDKPlugin/iOS/Mainland/ThirdPartSDK/WeChatSDK"));
				string str1Lib = LibWeChatDir + "/libWeChatSDK.a";
				PublicAdditionalLibraries.Add(str1Lib);
				
				string kuaishouSDKDir=Path.GetFullPath(System.IO.Path.Combine(ModuleDirectory,
					"../HeroUSDKPlugin/iOS/Mainland/ThirdPartSDK/KuaiShouShare"));
				string kuaishouLib = kuaishouSDKDir + "/libKwaiSDK.a";
				PublicAdditionalLibraries.Add(kuaishouLib);
				
				string weiboSDKDdir=Path.GetFullPath(System.IO.Path.Combine(ModuleDirectory,
					"../HeroUSDKPlugin/iOS/Mainland/ThirdPartSDK/libWeiboSDK"));
				string weiboLib = weiboSDKDdir + "/libWeiboSDK.a";
				PublicAdditionalLibraries.Add(weiboLib);
				
				if (bIsJuLiang)
				{
					string BDASignalSDKDir=System.IO.Path.GetFullPath(System.IO.Path.Combine(ModuleDirectory,
						"../HeroUSDKPlugin/iOS/Mainland/ThirdPartSDK/BDASignalSDK"));
					string BDALib = BDASignalSDKDir + "/libBDASignalSDK.a";
					PublicAdditionalLibraries.Add(BDALib);
				}
				
				PublicAdditionalFrameworks.Add(
				new Framework(
					"DouyinOpenSDK",
					"iOS/Mainland/ThirdPartSDK/DouyinUnionSDK/DouyinOpenSDK.embeddedframework.zip"
				)
			);
			
			if (bIsDouYin)
			{
				PublicAdditionalFrameworks.Add(
					new Framework(
						"BDAudioRecord",
						"iOS/Mainland/ThirdPartSDK/DouyinUnionSDK/BDAudioRecord.embeddedframework.zip"
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"BDAudioRecordResolver",
						"iOS/Mainland/ThirdPartSDK/DouyinUnionSDK/BDAudioRecordResolver.embeddedframework.zip"
					)
				);
				
				PublicAdditionalFrameworks.Add(
					new Framework(
						"UnionOpenPlatformCore",
						"iOS/Mainland/ThirdPartSDK/DouyinUnionSDK/UnionOpenPlatformCore.embeddedframework.zip"
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"UnionOpenPlatformDataLink",
						"iOS/Mainland/ThirdPartSDK/DouyinUnionSDK/UnionOpenPlatformDataLink.embeddedframework.zip"
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"UnionOpenPlatformDouyin",
						"iOS/Mainland/ThirdPartSDK/DouyinUnionSDK/UnionOpenPlatformDouyin.embeddedframework.zip"
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"UnionOpenPlatformReplay",
						"iOS/Mainland/ThirdPartSDK/DouyinUnionSDK/UnionOpenPlatformReplay.embeddedframework.zip"
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"UnionOpenPlatformShare",
						"iOS/Mainland/ThirdPartSDK/DouyinUnionSDK/UnionOpenPlatformShare.embeddedframework.zip"
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"UnionOpenPlatformTeamPlay",
						"iOS/Mainland/ThirdPartSDK/DouyinUnionSDK/UnionOpenPlatformTeamPlay.embeddedframework.zip"
					)
				);
			}

			#region taptap

			PublicAdditionalFrameworks.Add(
				new Framework(
					"tapsdkcorecpp",
					"iOS/Mainland/ThirdPartSDK/TapTapSDK/tapsdkcorecpp.embeddedframework.zip"
				)
			);
			PublicAdditionalFrameworks.Add(
				new Framework(
					"TapTapBasicToolsSDK",
					"iOS/Mainland/ThirdPartSDK/TapTapSDK/TapTapBasicToolsSDK.embeddedframework.zip"
				)
			);
			PublicAdditionalFrameworks.Add(
				new Framework(
					"TapTapCoreSDK",
					"iOS/Mainland/ThirdPartSDK/TapTapSDK/TapTapCoreSDK.embeddedframework.zip"
				)
			);
			PublicAdditionalFrameworks.Add(
				new Framework(
					"TapTapGidSDK",
					"iOS/Mainland/ThirdPartSDK/TapTapSDK/TapTapGidSDK.embeddedframework.zip"
				)
			);
			PublicAdditionalFrameworks.Add(
				new Framework(
					"TapTapLoginSDK",
					"iOS/Mainland/ThirdPartSDK/TapTapSDK/TapTapLoginSDK.embeddedframework.zip"
				)
			);
			PublicAdditionalFrameworks.Add(
				new Framework(
					"TapTapNetworkSDK",
					"iOS/Mainland/ThirdPartSDK/TapTapSDK/TapTapNetworkSDK.embeddedframework.zip"
				)
			);
			PublicAdditionalFrameworks.Add(
				new Framework(
					"TapTapShareSDK",
					"iOS/Mainland/ThirdPartSDK/TapTapSDK/TapTapShareSDK.embeddedframework.zip"
				)
			);
			PublicAdditionalFrameworks.Add(
				new Framework(
					"THEMISLite",
					"iOS/Mainland/ThirdPartSDK/TapTapSDK/THEMISLite.embeddedframework.zip"
				)
			);
		

			#endregion

			#region 小红书

			PublicAdditionalFrameworks.Add(
				new Framework(
					"XiaoHongShuOpenSDK",
					"iOS/Mainland/ThirdPartSDK/XHSShare/XiaoHongShuOpenSDK.embeddedframework.zip"
				)
			);

			#endregion
			
				// TODO remove or not ???
				PublicAdditionalFrameworks.Add(
					new Framework(
						"Bloc",
						"iOS/Mainland/ThirdPartSDK/Bloc.embeddedframework.zip",
						"BlocSDK.bundle"
					)
				);

				#region 手机号一键登录

				PublicAdditionalFrameworks.Add(
					new Framework(
						"account_login_sdk_noui_core",
						"iOS/Mainland/ThirdPartSDK/EPhone/account_login_sdk_noui_core.embeddedframework.zip"
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"CL_ShanYanSDK",
						"iOS/Mainland/ThirdPartSDK/EPhone/CL_ShanYanSDK.embeddedframework.zip"
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"EAccountApiSDK",
						"iOS/Mainland/ThirdPartSDK/EPhone/EAccountApiSDK.embeddedframework.zip"
					)
				);
				
				PublicAdditionalFrameworks.Add(
					new Framework(
						"TYRZUISDK",
						"iOS/Mainland/ThirdPartSDK/EPhone/TYRZUISDK.embeddedframework.zip"
					)
				);
				
				PublicAdditionalFrameworks.Add(
					new Framework(
						"OAuth",
						"iOS/Mainland/ThirdPartSDK/EPhone/OAuth.embeddedframework.zip"
					)
				);

				#endregion	
				
				
				PublicAdditionalFrameworks.Add(
					new Framework(
						"Game",
						"iOS/Mainland/Game.embeddedframework.zip"
					)
				);
				PublicAdditionalFrameworks.Add(
					new Framework(
						"HeroShareSDK",
						"iOS/Mainland/HeroShareSDK.embeddedframework.zip"
					)
				);
				
				
				PublicAdditionalFrameworks.Add(
					new Framework(
						"TencentOpenAPI",
						"iOS/Mainland/ThirdPartSDK/TencentSDK/TencentOpenAPI.embeddedframework.zip",
						"TencentOpenApi_IOS_Bundle.bundle"
					)
				);

				PublicAdditionalFrameworks.Add(
					new Framework(
						"HeroFloatSDK",
						"iOS/Mainland/HeroFloatSDK.embeddedframework.zip"
					)
				);

				PublicAdditionalLibraries.AddRange(
					new string[]
					{
						"c++",
						"sqlite3.0",
						"z",
						"iconv",
						"resolv"
					});
				
				PublicWeakFrameworks.AddRange(new string[]
				{
					"AuthenticationServices",
					"AppTrackingTransparency",
				});
				
				PublicFrameworks.AddRange(
					new string[]
					{
						"WebKit",
						"ImageIO",
						"StoreKit",
						"JavaScriptCore",
						"AdSupport",
						"Accounts",
						"CoreGraphics",
						"CoreTelephony",
						"Accelerate",
						"MapKit",
						"ExternalAccessory",
						"Security",
						"SystemConfiguration"
					});

				AdditionalPropertiesForReceipt.Add("IOSPlugin",
					Path.Combine(PluginPath, "HeroUSDKPlugin_UPL_Game.xml"));
			}

			PrivateDependencyModuleNames.Add("Launch");
		}
	}

	private Exception AppendChangeAdditionalCompilerArguments(ReadOnlyTargetRules target, params string[] args)
	{
		//参数为0，则返回报错
		if (args == null || args.Length == 0)
		{
			return new Exception("args is null or size is 0");
		}

		//构建拼接字符串
		StringBuilder arguments = new StringBuilder();
		arguments.Append(" ");
		for (var i = 0; i < args.Length; i++)
		{
			arguments.Append(args[i]);
			if (i < args.Length - 1)
			{
				arguments.Append(" ");
			}
		}

		try
		{
			//获取类型
			Type type = target.GetType();
			//获取实例的非public成员
			FieldInfo field = type.GetField("Inner",
				BindingFlags.Instance | BindingFlags.NonPublic
			);
			if (field == null)
			{
				return new Exception("not found {Inner} in target");
			}

			TargetRules innerRules = (TargetRules)field.GetValue(target);
			innerRules.AdditionalCompilerArguments += arguments.ToString();
			return null;
		}
		catch (Exception e)
		{
			return e;
		}
	}
	
	private Exception AppendChangeAdditionalLinkerArguments(ReadOnlyTargetRules target, params string[] args)
	{
		//参数为0，则返回报错
		if (args == null || args.Length == 0)
		{
			return new Exception("args is null or size is 0");
		}

		//构建拼接字符串
		StringBuilder arguments = new StringBuilder();
		arguments.Append(" ");
		for (var i = 0; i < args.Length; i++)
		{
			arguments.Append(args[i]);
			if (i < args.Length - 1)
			{
				arguments.Append(" ");
			}
		}

		try
		{
			//获取类型
			Type type = target.GetType();
			//获取实例的非public成员
			FieldInfo field = type.GetField("Inner",
				BindingFlags.Instance | BindingFlags.NonPublic
			);
			if (field == null)
			{
				return new Exception("not found {Inner} in target");
			}

			TargetRules innerRules = (TargetRules)field.GetValue(target);
			
			innerRules.AdditionalLinkerArguments += arguments.ToString();
			return null;
		}
		catch (Exception e)
		{
			return e;
		}
	}
	
	private void LoadDefaultEngineConfig()
	{
		// 获取配置文件路径
		string ProjectRoot = Path.GetFullPath(Path.Combine(ModuleDirectory, "../../../.."));
		string ConfigFilePath = Path.Combine(ProjectRoot, "Config", "DefaultGame.ini");
	
		if (File.Exists(ConfigFilePath))
		{
			string[] Lines = File.ReadAllLines(ConfigFilePath);
			foreach (string Line in Lines)
			{
				if (Line.Contains("bIsJuLiang"))
				{
					string[] keyVanle = Line.Split('=');
					if (keyVanle.Length==2&&keyVanle[0].Trim()=="bIsJuLiang")
					{
						bIsJuLiang=bool.Parse(keyVanle[1].Trim());
					}
					
				}
				if (Line.Contains("bIsDouYin"))
				{
					string[] keyVanle = Line.Split('=');
					if (keyVanle.Length==2&&keyVanle[0].Trim()=="bIsDouYin")
					{
						bIsDouYin=bool.Parse(keyVanle[1].Trim());
					}
				}
			}
		}
		else
		{
			System.Console.WriteLine("DefaultEngine.ini 文件未找到！");
		}
	
			
			
		
	}
	void DownloadImageAsync()
{
    string urlImage="";

    string ProjectRoot = Path.GetFullPath(Path.Combine(ModuleDirectory, "../../../.."));
    string ConfigFilePath = Path.Combine(ProjectRoot, "Config", "DefaultGame.ini");

    string savePath =Path.Combine(ProjectRoot, "Plugins/HeroUSDKPlugin/Source/Img", "black_gold_Hero_logo@2x.png");
    string[] imgName = new string[3]
       {  "black_gold_Hero_logo@3x.png", "Hero_logo@2x.png", "Hero_logo@3x.png" };
    Console.WriteLine("savepath==="+savePath); 
    if (File.Exists(ConfigFilePath))  
    {
       string[] Lines = File.ReadAllLines(ConfigFilePath);
       foreach (string Line in Lines)
       {
          if (Line.Contains("iconPath"))
          {
             string[] keyVanle = Line.Split('=');
             if (keyVanle.Length==2&&keyVanle[0].Trim()=="iconPath")
             {
                urlImage = keyVanle[1];
                urlImage=urlImage.Substring(1, urlImage.Length - 2); 
                Console.WriteLine("urlimg========="+urlImage); 
                bool isDown= DownloadFile(urlImage, savePath);
                if (isDown)
                {
                   foreach (var VARIABLE in imgName)
                   {
                      string sourceFilePath=Path.Combine(ProjectRoot, "Plugins/HeroUSDKPlugin/Source/Img", "black_gold_Hero_logo@2x.png");
                      string destinationFilePath=Path.Combine(ProjectRoot, "Plugins/HeroUSDKPlugin/Source/Img", VARIABLE);
                      File.Copy(sourceFilePath, destinationFilePath, true);
                   }

                   CopyImgFranework();
                }
             }

          }
       }
    }

}

private bool DownloadFile(string url, string destinationPath)
{
    try
    {
       System.Console.WriteLine("Downloading file from: " + url);
       System.Console.WriteLine("Destination: " + destinationPath);

       // Create directory if it doesn't exist
       string directory = Path.GetDirectoryName(destinationPath);
       if (!Directory.Exists(directory))
       {
          Directory.CreateDirectory(directory);
       }

       // Download the file
       using (System.Net.WebClient client = new System.Net.WebClient())
       {
          client.DownloadFile(url, destinationPath);
       }

       System.Console.WriteLine("File downloaded successfully.");
       return true;
    }
    catch (Exception ex)
    {
       System.Console.WriteLine("Error downloading file: " + ex.Message);
       return false;
    }
}

private void CopyImgFranework()
{
    string ProjectRoot = Path.GetFullPath(Path.Combine(ModuleDirectory, "../../../.."));
    string[] imgName = new string[4]
       {  "black_gold_Hero_logo@2x.png","black_gold_Hero_logo@3x.png", "Hero_logo@2x.png", "Hero_logo@3x.png" };
    string[] png2xStrings = new string[2] { "black_gold_Hero_logo@2x.png", "Hero_logo@2x.png" };
    for (int i = 0; i < png2xStrings.Length; i++)
    {
       string img2path=Path.Combine(ProjectRoot, "Plugins/HeroUSDKPlugin/Source/Img", png2xStrings[i]);
       GetImageDimensions(img2path);
    }
    foreach (var VARIABLE in imgName)
    {
       string sourceFilePath=Path.Combine(ProjectRoot, "Plugins/HeroUSDKPlugin/Source/Img", VARIABLE);
       string destinationFilePath=Path.Combine(ProjectRoot, "Plugins/HeroUSDKPlugin/Source/HeroUSDKPlugin/iOS/Global/HeroGlobalSDK.framework/HeroResource.bundle/Images", VARIABLE);
       /*string destinationFilePath1 =
          @"D:\whp\UEUSDK\Plugins\HeroUSDKPlugin\Source\HeroUSDKPlugin\iOS\Global\HeroGlobalSDK.framework\HeroResource.bundle\Images\" +
          VARIABLE;*/
       Console.WriteLine("destinationFilePath"+destinationFilePath);  
       File.Copy(sourceFilePath, destinationFilePath, true);
    }
    string embeddedzip=Path.Combine(PluginDirectory, "Source/HeroUSDKPlugin/iOS/Global", "HeroGlobalSDK.embeddedframework.zip");
    if (File.Exists(embeddedzip))
    {
       File.Delete(embeddedzip);
    }
    string HeroGlobalSDKpath=Path.Combine(PluginDirectory, "Source/HeroUSDKPlugin/iOS/Global", "HeroGlobalSDK.embeddedframework");
    if (!Directory.Exists(HeroGlobalSDKpath))
    {
       Directory.CreateDirectory(HeroGlobalSDKpath);

    }
    string HeroGlobalSDKpathFramework=Path.Combine(PluginDirectory, "Source/HeroUSDKPlugin/iOS/Global", "HeroGlobalSDK.framework");
    string HeroGlobalSDKpathFrawork=Path.Combine(PluginDirectory, "Source/HeroUSDKPlugin/iOS/Global/HeroGlobalSDK.embeddedframework", "HeroGlobalSDK.framework");




    CopyDirectory(HeroGlobalSDKpathFramework, HeroGlobalSDKpathFrawork);


    CompressDirectory(HeroGlobalSDKpath, HeroGlobalSDKpath + ".zip");
    Console.WriteLine("========");
}

void CopyDirectory(string sourceDir, string destinationDir)
{
    // Create the destination directory if it doesn't exist
    Directory.CreateDirectory(destinationDir);

    // Get the files in the directory and copy them to the new location
    foreach (string file in Directory.GetFiles(sourceDir))
    {
       string fileName = Path.GetFileName(file);
       string destFile = Path.Combine(destinationDir, fileName);
       File.Copy(file, destFile, true); // true to overwrite if the file exists
       //Console.WriteLine($"Copied: {file} to {destFile}");
       
    }

    // Copy subdirectories and their contents
    foreach (string subdirectory in Directory.GetDirectories(sourceDir))
    {
       string subdirectoryName = Path.GetFileName(subdirectory);
       string destSubdirectory = Path.Combine(destinationDir, subdirectoryName);
       CopyDirectory(subdirectory, destSubdirectory); // Recursive call
    }
}

public void CompressDirectory(string sourceDirectory, string outputFile)
{
    // 确保输出文件路径以.tar结尾

    ProcessStartInfo startInfo = new ProcessStartInfo
    {
       FileName = "/bin/bash",
       Arguments = string.Format("-c \"cd '{0}'&& cd .. && zip -r '{1}' HeroGlobalSDK.embeddedframework  && rm -rf HeroGlobalSDK.embeddedframework\"", sourceDirectory, outputFile),
       RedirectStandardOutput = true,
       UseShellExecute = false,
       CreateNoWindow = true,
    };

    using (Process process = Process.Start(startInfo))
    {
       process.WaitForExit(); // 等待进程结束
       
    }
}

private void SetImg(int height,int width,string imgPath)
{
    ProcessStartInfo startInfo = new ProcessStartInfo
    {
       FileName = "sips",
       Arguments = string.Format("-z {0} {1} \"{2}\" -o \"{3}\"", height, width, imgPath, imgPath),
       RedirectStandardOutput = true,
       UseShellExecute = false,
       CreateNoWindow = true,
    };

    using (Process process = Process.Start(startInfo))
    {
       process.WaitForExit(); // 等待进程结束
       
    }
}

void GetImageDimensions(string imagePath)
{
    var process = new Process
    {
       StartInfo = new ProcessStartInfo
       {
          FileName = "sips",
          Arguments = string.Format("-g pixelWidth -g pixelHeight \"{0}\"", imagePath),
          RedirectStandardOutput = true,
          RedirectStandardError = true,
          UseShellExecute = false,
          CreateNoWindow = true
       }
    };

    process.Start();
    string output = process.StandardOutput.ReadToEnd();
    process.WaitForExit();

    if (process.ExitCode != 0)
    {
       string error = process.StandardError.ReadToEnd();
       throw new Exception(string.Format("sips 执行失败: {0}", error));
    }

    Console.WriteLine("output===="+output);
    var widthMatch = Regex.Match(output, @"pixelWidth:\s*(\d+)");

    var heightMatch = Regex.Match(output, @"pixelHeight:\s*(\d+)");

    int width = int.Parse(widthMatch.Groups[1].Value);
    int height = int.Parse(heightMatch.Groups[1].Value);
    width = width / 3 * 2;
    height = height / 3 * 2;
    SetImg(height, width, imagePath);

}

}